'use strict';

var React = require('react');
var Animated = require('react-native-reanimated');
var list = require('@legendapp/list');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React__namespace = /*#__PURE__*/_interopNamespace(React);
var Animated__default = /*#__PURE__*/_interopDefault(Animated);

// src/integrations/reanimated.tsx

// src/utils/helpers.ts
function isFunction(obj) {
  return typeof obj === "function";
}

// src/hooks/useCombinedRef.ts
var useCombinedRef = (...refs) => {
  const callback = React.useCallback((element) => {
    for (const ref of refs) {
      if (!ref) {
        continue;
      }
      if (isFunction(ref)) {
        ref(element);
      } else {
        ref.current = element;
      }
    }
  }, refs);
  return callback;
};

// src/integrations/reanimated.tsx
var typedMemo = React.memo;
var LegendListForwardedRef = typedMemo(
  React__namespace.forwardRef(function LegendListForwardedRef2(props, ref) {
    const { refLegendList, ...rest } = props;
    const refFn = React.useCallback(
      (r) => {
        refLegendList(r);
      },
      [refLegendList]
    );
    return /* @__PURE__ */ React__namespace.createElement(list.LegendList, { ref: refFn, refScrollView: ref, ...rest });
  })
);
var AnimatedLegendListComponent = Animated__default.default.createAnimatedComponent(LegendListForwardedRef);
var AnimatedLegendList = typedMemo(
  React__namespace.forwardRef(function AnimatedLegendList2(props, ref) {
    const { refScrollView, ...rest } = props;
    const refLegendList = React__namespace.useRef(null);
    const combinedRef = useCombinedRef(refLegendList, ref);
    return /* @__PURE__ */ React__namespace.createElement(AnimatedLegendListComponent, { ref: refScrollView, refLegendList: combinedRef, ...rest });
  })
);

exports.AnimatedLegendList = AnimatedLegendList;
