'use strict';

var React2 = require('react');
var reactNative = require('react-native');
var shim = require('use-sync-external-store/shim');

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var React2__namespace = /*#__PURE__*/_interopNamespace(React2);

// src/components/LegendList.tsx
var ContextState = React2__namespace.createContext(null);
function StateProvider({ children }) {
  const [value] = React2__namespace.useState(() => ({
    animatedScrollY: new reactNative.Animated.Value(0),
    columnWrapperStyle: void 0,
    internalState: void 0,
    listeners: /* @__PURE__ */ new Map(),
    mapViewabilityAmountCallbacks: /* @__PURE__ */ new Map(),
    mapViewabilityAmountValues: /* @__PURE__ */ new Map(),
    mapViewabilityCallbacks: /* @__PURE__ */ new Map(),
    mapViewabilityConfigStates: /* @__PURE__ */ new Map(),
    mapViewabilityValues: /* @__PURE__ */ new Map(),
    values: /* @__PURE__ */ new Map([
      ["alignItemsPaddingTop", 0],
      ["stylePaddingTop", 0],
      ["headerSize", 0],
      ["numContainers", 0],
      ["totalSize", 0]
    ]),
    viewRefs: /* @__PURE__ */ new Map()
  }));
  return /* @__PURE__ */ React2__namespace.createElement(ContextState.Provider, { value }, children);
}
function useStateContext() {
  return React2__namespace.useContext(ContextState);
}
function createSelectorFunctionsArr(ctx, signalNames) {
  let lastValues = [];
  let lastSignalValues = [];
  return {
    get: () => {
      const currentValues = [];
      let hasChanged = false;
      for (let i = 0; i < signalNames.length; i++) {
        const value = peek$(ctx, signalNames[i]);
        currentValues.push(value);
        if (value !== lastSignalValues[i]) {
          hasChanged = true;
        }
      }
      lastSignalValues = currentValues;
      if (hasChanged) {
        lastValues = currentValues;
      }
      return lastValues;
    },
    subscribe: (cb) => {
      const listeners = [];
      for (const signalName of signalNames) {
        listeners.push(listen$(ctx, signalName, cb));
      }
      return () => {
        for (const listener of listeners) {
          listener();
        }
      };
    }
  };
}
function listen$(ctx, signalName, cb) {
  const { listeners } = ctx;
  let setListeners = listeners.get(signalName);
  if (!setListeners) {
    setListeners = /* @__PURE__ */ new Set();
    listeners.set(signalName, setListeners);
  }
  setListeners.add(cb);
  return () => setListeners.delete(cb);
}
function peek$(ctx, signalName) {
  const { values } = ctx;
  return values.get(signalName);
}
function set$(ctx, signalName, value) {
  const { listeners, values } = ctx;
  if (values.get(signalName) !== value) {
    values.set(signalName, value);
    const setListeners = listeners.get(signalName);
    if (setListeners) {
      for (const listener of setListeners) {
        listener(value);
      }
    }
  }
}
function getContentSize(ctx) {
  const { values } = ctx;
  const stylePaddingTop = values.get("stylePaddingTop") || 0;
  const headerSize = values.get("headerSize") || 0;
  const footerSize = values.get("footerSize") || 0;
  const totalSize = values.get("totalSize");
  return headerSize + footerSize + totalSize + stylePaddingTop;
}
function useArr$(signalNames) {
  const ctx = React2__namespace.useContext(ContextState);
  const { subscribe, get } = React2__namespace.useMemo(() => createSelectorFunctionsArr(ctx, signalNames), [ctx, signalNames]);
  const value = shim.useSyncExternalStore(subscribe, get);
  return value;
}
function useSelector$(signalName, selector) {
  const ctx = React2__namespace.useContext(ContextState);
  const { subscribe, get } = React2__namespace.useMemo(() => createSelectorFunctionsArr(ctx, [signalName]), [ctx, signalName]);
  const value = shim.useSyncExternalStore(subscribe, () => selector(get()[0]));
  return value;
}

// src/components/DebugView.tsx
var DebugRow = ({ children }) => {
  return /* @__PURE__ */ React2__namespace.createElement(reactNative.View, { style: { alignItems: "center", flexDirection: "row", justifyContent: "space-between" } }, children);
};
var DebugView = React2__namespace.memo(function DebugView2({ state }) {
  const ctx = useStateContext();
  const [totalSize = 0, scrollAdjust = 0, rawScroll = 0, scroll = 0, _numContainers = 0, _numContainersPooled = 0] = useArr$([
    "totalSize",
    "scrollAdjust",
    "debugRawScroll",
    "debugComputedScroll",
    "numContainers",
    "numContainersPooled"
  ]);
  const contentSize = getContentSize(ctx);
  const [, forceUpdate] = React2.useReducer((x) => x + 1, 0);
  useInterval(() => {
    forceUpdate();
  }, 100);
  return /* @__PURE__ */ React2__namespace.createElement(
    reactNative.View,
    {
      pointerEvents: "none",
      style: {
        // height: 100,
        backgroundColor: "#FFFFFFCC",
        borderRadius: 4,
        padding: 4,
        paddingBottom: 4,
        paddingLeft: 4,
        position: "absolute",
        right: 0,
        top: 0
      }
    },
    /* @__PURE__ */ React2__namespace.createElement(DebugRow, null, /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, "TotalSize:"), /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, totalSize.toFixed(2))),
    /* @__PURE__ */ React2__namespace.createElement(DebugRow, null, /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, "ContentSize:"), /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, contentSize.toFixed(2))),
    /* @__PURE__ */ React2__namespace.createElement(DebugRow, null, /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, "At end:"), /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, String(state.isAtEnd))),
    /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null),
    /* @__PURE__ */ React2__namespace.createElement(DebugRow, null, /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, "ScrollAdjust:"), /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, scrollAdjust.toFixed(2))),
    /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null),
    /* @__PURE__ */ React2__namespace.createElement(DebugRow, null, /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, "RawScroll: "), /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, rawScroll.toFixed(2))),
    /* @__PURE__ */ React2__namespace.createElement(DebugRow, null, /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, "ComputedScroll: "), /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, null, scroll.toFixed(2)))
  );
});
function useInterval(callback, delay) {
  React2.useEffect(() => {
    const interval = setInterval(callback, delay);
    return () => clearInterval(interval);
  }, [delay]);
}

// src/constants.ts
var POSITION_OUT_OF_VIEW = -1e7;
var ENABLE_DEVMODE = __DEV__ && false;
var ENABLE_DEBUG_VIEW = __DEV__ && false;
var IsNewArchitecture = global.nativeFabricUIManager != null;
var useAnimatedValue = (initialValue) => {
  return React2.useRef(new reactNative.Animated.Value(initialValue)).current;
};

// src/hooks/useValue$.ts
function useValue$(key, params) {
  var _a;
  const { getValue, delay } = params || {};
  const ctx = useStateContext();
  const animValue = useAnimatedValue((_a = getValue ? getValue(peek$(ctx, key)) : peek$(ctx, key)) != null ? _a : 0);
  React2.useMemo(() => {
    let newValue;
    let prevValue;
    let didQueueTask = false;
    listen$(ctx, key, (v) => {
      newValue = getValue ? getValue(v) : v;
      if (delay !== void 0) {
        const fn = () => {
          didQueueTask = false;
          if (newValue !== void 0) {
            animValue.setValue(newValue);
          }
        };
        const delayValue = typeof delay === "function" ? delay(newValue, prevValue) : delay;
        prevValue = newValue;
        if (!didQueueTask) {
          didQueueTask = true;
          if (delayValue === void 0) {
            fn();
          } else if (delayValue === 0) {
            queueMicrotask(fn);
          } else {
            setTimeout(fn, delayValue);
          }
        }
      } else {
        animValue.setValue(newValue);
      }
    });
  }, []);
  return animValue;
}
var typedForwardRef = React2.forwardRef;
var typedMemo = React2.memo;

// src/components/PositionView.tsx
var PositionViewState = typedMemo(function PositionView({
  id,
  horizontal,
  style,
  refView,
  ...rest
}) {
  const [position = POSITION_OUT_OF_VIEW] = useArr$([`containerPosition${id}`]);
  return /* @__PURE__ */ React2__namespace.createElement(
    reactNative.View,
    {
      ref: refView,
      style: [
        style,
        horizontal ? { transform: [{ translateX: position }] } : { transform: [{ translateY: position }] }
      ],
      ...rest
    }
  );
});
var PositionViewAnimated = typedMemo(function PositionView2({
  id,
  horizontal,
  style,
  refView,
  ...rest
}) {
  const position$ = useValue$(`containerPosition${id}`, {
    getValue: (v) => v != null ? v : POSITION_OUT_OF_VIEW
  });
  let position;
  if (reactNative.Platform.OS === "ios" || reactNative.Platform.OS === "android") {
    position = horizontal ? { transform: [{ translateX: position$ }] } : { transform: [{ translateY: position$ }] };
  } else {
    position = horizontal ? { left: position$ } : { top: position$ };
  }
  return /* @__PURE__ */ React2__namespace.createElement(reactNative.Animated.View, { ref: refView, style: [style, position], ...rest });
});
var PositionViewSticky = typedMemo(function PositionViewSticky2({
  id,
  horizontal,
  style,
  refView,
  animatedScrollY,
  stickyOffset,
  index,
  ...rest
}) {
  const [position = POSITION_OUT_OF_VIEW, headerSize] = useArr$([`containerPosition${id}`, "headerSize"]);
  const transform = React2__namespace.useMemo(() => {
    if (animatedScrollY && stickyOffset !== void 0) {
      const stickyPosition = animatedScrollY.interpolate({
        extrapolate: "clamp",
        inputRange: [position + headerSize, position + 5e3 + headerSize],
        outputRange: [position, position + 5e3]
      });
      return horizontal ? [{ translateX: stickyPosition }] : [{ translateY: stickyPosition }];
    }
  }, [animatedScrollY, headerSize, horizontal, stickyOffset, position]);
  const viewStyle = React2__namespace.useMemo(() => [style, { zIndex: index + 1e3 }, { transform }], [style, transform]);
  return /* @__PURE__ */ React2__namespace.createElement(reactNative.Animated.View, { ref: refView, style: viewStyle, ...rest });
});
var PositionView3 = IsNewArchitecture ? PositionViewState : PositionViewAnimated;
var symbolFirst = Symbol();
function useInit(cb) {
  const refValue = React2.useRef(symbolFirst);
  if (refValue.current === symbolFirst) {
    refValue.current = cb();
  }
  return refValue.current;
}

// src/utils/helpers.ts
function isFunction(obj) {
  return typeof obj === "function";
}
function isArray(obj) {
  return Array.isArray(obj);
}
var warned = /* @__PURE__ */ new Set();
function warnDevOnce(id, text) {
  if (__DEV__ && !warned.has(id)) {
    warned.add(id);
    console.warn(`[legend-list] ${text}`);
  }
}
function roundSize(size) {
  return Math.floor(size * 8) / 8;
}
function isNullOrUndefined(value) {
  return value === null || value === void 0;
}
function comparatorDefault(a, b) {
  return a - b;
}
function getPadding(s, type) {
  var _a, _b, _c;
  return (_c = (_b = (_a = s[`padding${type}`]) != null ? _a : s.paddingVertical) != null ? _b : s.padding) != null ? _c : 0;
}
function extractPadding(style, contentContainerStyle, type) {
  return getPadding(style, type) + getPadding(contentContainerStyle, type);
}

// src/state/ContextContainer.ts
var ContextContainer = React2.createContext(null);
function useViewability(callback, configId) {
  const ctx = useStateContext();
  const { containerId } = React2.useContext(ContextContainer);
  const key = containerId + (configId != null ? configId : "");
  useInit(() => {
    const value = ctx.mapViewabilityValues.get(key);
    if (value) {
      callback(value);
    }
  });
  ctx.mapViewabilityCallbacks.set(key, callback);
  React2.useEffect(
    () => () => {
      ctx.mapViewabilityCallbacks.delete(key);
    },
    []
  );
}
function useViewabilityAmount(callback) {
  const ctx = useStateContext();
  const { containerId } = React2.useContext(ContextContainer);
  useInit(() => {
    const value = ctx.mapViewabilityAmountValues.get(containerId);
    if (value) {
      callback(value);
    }
  });
  ctx.mapViewabilityAmountCallbacks.set(containerId, callback);
  React2.useEffect(
    () => () => {
      ctx.mapViewabilityAmountCallbacks.delete(containerId);
    },
    []
  );
}
function useRecyclingEffect(effect) {
  const { index, value } = React2.useContext(ContextContainer);
  const prevValues = React2.useRef({
    prevIndex: void 0,
    prevItem: void 0
  });
  React2.useEffect(() => {
    let ret;
    if (prevValues.current.prevIndex !== void 0 && prevValues.current.prevItem !== void 0) {
      ret = effect({
        index,
        item: value,
        prevIndex: prevValues.current.prevIndex,
        prevItem: prevValues.current.prevItem
      });
    }
    prevValues.current = {
      prevIndex: index,
      prevItem: value
    };
    return ret;
  }, [index, value, effect]);
}
function useRecyclingState(valueOrFun) {
  const { index, value, itemKey, triggerLayout } = React2.useContext(ContextContainer);
  const refState = React2.useRef({
    itemKey: null,
    value: null
  });
  const [_, setRenderNum] = React2.useState(0);
  const state = refState.current;
  if (state.itemKey !== itemKey) {
    state.itemKey = itemKey;
    state.value = isFunction(valueOrFun) ? valueOrFun({
      index,
      item: value,
      prevIndex: void 0,
      prevItem: void 0
    }) : valueOrFun;
  }
  const setState = React2.useCallback(
    (newState) => {
      state.value = isFunction(newState) ? newState(state.value) : newState;
      setRenderNum((v) => v + 1);
      triggerLayout();
    },
    [triggerLayout, state]
  );
  return [state.value, setState];
}
function useIsLastItem() {
  const { itemKey } = React2.useContext(ContextContainer);
  const isLast = useSelector$("lastItemKeys", (lastItemKeys) => (lastItemKeys == null ? void 0 : lastItemKeys.includes(itemKey)) || false);
  return isLast;
}
function useListScrollSize() {
  const [scrollSize] = useArr$(["scrollSize"]);
  return scrollSize;
}
var noop = () => {
};
function useSyncLayout() {
  if (IsNewArchitecture) {
    const { triggerLayout: syncLayout } = React2.useContext(ContextContainer);
    return syncLayout;
  } else {
    return noop;
  }
}

// src/components/Separator.tsx
function Separator({ ItemSeparatorComponent, leadingItem }) {
  const isLastItem = useIsLastItem();
  return isLastItem ? null : /* @__PURE__ */ React2__namespace.createElement(ItemSeparatorComponent, { leadingItem });
}
function useOnLayoutSync({
  ref,
  onLayoutProp,
  onLayoutChange
}, deps = []) {
  const onLayout = React2.useCallback(
    (event) => {
      onLayoutChange(event.nativeEvent.layout, false);
      onLayoutProp == null ? void 0 : onLayoutProp(event);
    },
    [onLayoutChange]
  );
  if (IsNewArchitecture) {
    React2.useLayoutEffect(() => {
      if (ref.current) {
        ref.current.measure((x, y, width, height) => {
          onLayoutChange({ height, width, x, y }, true);
        });
      }
    }, deps);
  }
  return { onLayout };
}

// src/components/Container.tsx
var Container = typedMemo(function Container2({
  id,
  recycleItems,
  horizontal,
  getRenderedItem: getRenderedItem2,
  updateItemSize: updateItemSize2,
  ItemSeparatorComponent
}) {
  const ctx = useStateContext();
  const { columnWrapperStyle, animatedScrollY } = ctx;
  const [column = 0, data, itemKey, numColumns, extraData, isSticky, stickyOffset] = useArr$([
    `containerColumn${id}`,
    `containerItemData${id}`,
    `containerItemKey${id}`,
    "numColumns",
    "extraData",
    `containerSticky${id}`,
    `containerStickyOffset${id}`
  ]);
  const refLastSize = React2.useRef();
  const ref = React2.useRef(null);
  const [layoutRenderCount, forceLayoutRender] = React2.useState(0);
  const otherAxisPos = numColumns > 1 ? `${(column - 1) / numColumns * 100}%` : 0;
  const otherAxisSize = numColumns > 1 ? `${1 / numColumns * 100}%` : void 0;
  const didLayoutRef = React2.useRef(false);
  const style = React2.useMemo(() => {
    let paddingStyles;
    if (columnWrapperStyle) {
      const { columnGap, rowGap, gap } = columnWrapperStyle;
      if (horizontal) {
        paddingStyles = {
          paddingRight: columnGap || gap || void 0,
          paddingVertical: numColumns > 1 ? (rowGap || gap || 0) / 2 : void 0
        };
      } else {
        paddingStyles = {
          paddingBottom: rowGap || gap || void 0,
          paddingHorizontal: numColumns > 1 ? (columnGap || gap || 0) / 2 : void 0
        };
      }
    }
    return horizontal ? {
      flexDirection: ItemSeparatorComponent ? "row" : void 0,
      height: otherAxisSize,
      left: 0,
      position: "absolute",
      top: otherAxisPos,
      ...paddingStyles || {}
    } : {
      left: otherAxisPos,
      position: "absolute",
      right: numColumns > 1 ? null : 0,
      top: 0,
      width: otherAxisSize,
      ...paddingStyles || {}
    };
  }, [horizontal, otherAxisPos, otherAxisSize, columnWrapperStyle, numColumns]);
  const renderedItemInfo = React2.useMemo(
    () => itemKey !== void 0 ? getRenderedItem2(itemKey) : null,
    [itemKey, data, extraData]
  );
  const { index, renderedItem } = renderedItemInfo || {};
  const contextValue = React2.useMemo(() => {
    ctx.viewRefs.set(id, ref);
    return {
      containerId: id,
      index,
      itemKey,
      triggerLayout: () => {
        forceLayoutRender((v) => v + 1);
      },
      value: data
    };
  }, [id, itemKey, index, data]);
  const onLayoutChange = (rectangle) => {
    var _a, _b;
    if (!isNullOrUndefined(itemKey)) {
      didLayoutRef.current = true;
      let layout = rectangle;
      const size = Math.floor(rectangle[horizontal ? "width" : "height"] * 8) / 8;
      const doUpdate = () => {
        refLastSize.current = { height: layout.height, width: layout.width };
        updateItemSize2(itemKey, layout);
        didLayoutRef.current = true;
      };
      if (IsNewArchitecture || size > 0) {
        doUpdate();
      } else {
        (_b = (_a = ref.current) == null ? void 0 : _a.measure) == null ? void 0 : _b.call(_a, (_x, _y, width, height) => {
          layout = { height, width };
          doUpdate();
        });
      }
    }
  };
  const { onLayout } = useOnLayoutSync(
    {
      onLayoutChange,
      ref
    },
    [itemKey, layoutRenderCount]
  );
  if (!IsNewArchitecture) {
    React2.useEffect(() => {
      if (!isNullOrUndefined(itemKey)) {
        const timeout = setTimeout(() => {
          if (!didLayoutRef.current && refLastSize.current) {
            updateItemSize2(itemKey, refLastSize.current);
            didLayoutRef.current = true;
          }
        }, 16);
        return () => {
          clearTimeout(timeout);
        };
      }
    }, [itemKey]);
  }
  const PositionComponent = isSticky ? PositionViewSticky : PositionView3;
  return /* @__PURE__ */ React2__namespace.createElement(
    PositionComponent,
    {
      animatedScrollY: isSticky ? animatedScrollY : void 0,
      horizontal,
      id,
      index,
      key: recycleItems ? void 0 : itemKey,
      onLayout,
      refView: ref,
      stickyOffset: isSticky ? stickyOffset : void 0,
      style
    },
    /* @__PURE__ */ React2__namespace.createElement(ContextContainer.Provider, { value: contextValue }, renderedItem, renderedItemInfo && ItemSeparatorComponent && /* @__PURE__ */ React2__namespace.createElement(Separator, { ItemSeparatorComponent, leadingItem: renderedItemInfo.item }))
  );
});

// src/components/Containers.tsx
var Containers = typedMemo(function Containers2({
  horizontal,
  recycleItems,
  ItemSeparatorComponent,
  waitForInitialLayout,
  updateItemSize: updateItemSize2,
  getRenderedItem: getRenderedItem2
}) {
  const ctx = useStateContext();
  const columnWrapperStyle = ctx.columnWrapperStyle;
  const [numContainers, numColumns] = useArr$(["numContainersPooled", "numColumns"]);
  const animSize = useValue$("totalSize", {
    // Use a microtask if increasing the size significantly, otherwise use a timeout
    // If this is the initial scroll, we don't want to delay because we want to update the size immediately
    delay: (value, prevValue) => {
      var _a;
      return !((_a = ctx.internalState) == null ? void 0 : _a.initialScroll) ? !prevValue || value - prevValue > 20 ? 0 : 200 : void 0;
    }
  });
  const animOpacity = waitForInitialLayout && !IsNewArchitecture ? useValue$("containersDidLayout", { getValue: (value) => value ? 1 : 0 }) : void 0;
  const otherAxisSize = useValue$("otherAxisSize", { delay: 0 });
  const containers = [];
  for (let i = 0; i < numContainers; i++) {
    containers.push(
      /* @__PURE__ */ React2__namespace.createElement(
        Container,
        {
          getRenderedItem: getRenderedItem2,
          horizontal,
          ItemSeparatorComponent,
          id: i,
          key: i,
          recycleItems,
          updateItemSize: updateItemSize2
        }
      )
    );
  }
  const style = horizontal ? { minHeight: otherAxisSize, opacity: animOpacity, width: animSize } : { height: animSize, minWidth: otherAxisSize, opacity: animOpacity };
  if (columnWrapperStyle && numColumns > 1) {
    const { columnGap, rowGap, gap } = columnWrapperStyle;
    const gapX = columnGap || gap || 0;
    const gapY = rowGap || gap || 0;
    if (horizontal) {
      if (gapY) {
        style.marginVertical = -gapY / 2;
      }
      if (gapX) {
        style.marginRight = -gapX;
      }
    } else {
      if (gapX) {
        style.marginHorizontal = -gapX;
      }
      if (gapY) {
        style.marginBottom = -gapY;
      }
    }
  }
  return /* @__PURE__ */ React2__namespace.createElement(reactNative.Animated.View, { style }, containers);
});
var LayoutView = ({ onLayoutChange, refView, ...rest }) => {
  const ref = refView != null ? refView : React2.useRef();
  const { onLayout } = useOnLayoutSync({ onLayoutChange, ref });
  return /* @__PURE__ */ React2__namespace.createElement(reactNative.View, { ...rest, onLayout, ref });
};
function ScrollAdjust() {
  const bias = 1e7;
  const [scrollAdjust, scrollAdjustUserOffset] = useArr$(["scrollAdjust", "scrollAdjustUserOffset"]);
  const scrollOffset = (scrollAdjust || 0) + (scrollAdjustUserOffset || 0) + bias;
  return /* @__PURE__ */ React2__namespace.createElement(
    reactNative.View,
    {
      style: {
        height: 0,
        left: 0,
        position: "absolute",
        top: scrollOffset,
        width: 0
      }
    }
  );
}
function SnapWrapper({ ScrollComponent, ...props }) {
  const [snapToOffsets] = useArr$(["snapToOffsets"]);
  return /* @__PURE__ */ React2__namespace.createElement(ScrollComponent, { ...props, snapToOffsets });
}

// src/components/ListComponent.tsx
var getComponent = (Component) => {
  if (React2__namespace.isValidElement(Component)) {
    return Component;
  }
  if (Component) {
    return /* @__PURE__ */ React2__namespace.createElement(Component, null);
  }
  return null;
};
var Padding = () => {
  const animPaddingTop = useValue$("alignItemsPaddingTop", { delay: 0 });
  return /* @__PURE__ */ React2__namespace.createElement(reactNative.Animated.View, { style: { paddingTop: animPaddingTop } });
};
var PaddingDevMode = () => {
  const animPaddingTop = useValue$("alignItemsPaddingTop", { delay: 0 });
  return /* @__PURE__ */ React2__namespace.createElement(React2__namespace.Fragment, null, /* @__PURE__ */ React2__namespace.createElement(reactNative.Animated.View, { style: { paddingTop: animPaddingTop } }), /* @__PURE__ */ React2__namespace.createElement(
    reactNative.Animated.View,
    {
      style: {
        backgroundColor: "green",
        height: animPaddingTop,
        left: 0,
        position: "absolute",
        right: 0,
        top: 0
      }
    }
  ));
};
var ListComponent = typedMemo(function ListComponent2({
  canRender,
  style,
  contentContainerStyle,
  horizontal,
  initialContentOffset,
  recycleItems,
  ItemSeparatorComponent,
  alignItemsAtEnd,
  waitForInitialLayout,
  onScroll: onScroll2,
  onLayout,
  ListHeaderComponent,
  ListHeaderComponentStyle,
  ListFooterComponent,
  ListFooterComponentStyle,
  ListEmptyComponent,
  getRenderedItem: getRenderedItem2,
  updateItemSize: updateItemSize2,
  refScrollView,
  maintainVisibleContentPosition,
  renderScrollComponent,
  scrollAdjustHandler,
  onLayoutHeader,
  snapToIndices,
  stickyIndices,
  ...rest
}) {
  const ctx = useStateContext();
  const ScrollComponent = renderScrollComponent ? React2.useMemo(
    () => React2__namespace.forwardRef((props, ref) => renderScrollComponent({ ...props, ref })),
    [renderScrollComponent]
  ) : reactNative.Animated.ScrollView;
  React2__namespace.useEffect(() => {
    if (canRender) {
      setTimeout(() => {
        scrollAdjustHandler.setMounted();
      }, 0);
    }
  }, [canRender]);
  const SnapOrScroll = snapToIndices ? SnapWrapper : ScrollComponent;
  return /* @__PURE__ */ React2__namespace.createElement(
    SnapOrScroll,
    {
      ...rest,
      contentContainerStyle: [
        contentContainerStyle,
        horizontal ? {
          height: "100%"
        } : {}
      ],
      contentOffset: initialContentOffset ? horizontal ? { x: initialContentOffset, y: 0 } : { x: 0, y: initialContentOffset } : void 0,
      horizontal,
      maintainVisibleContentPosition: maintainVisibleContentPosition ? { minIndexForVisible: 0 } : void 0,
      onLayout,
      onScroll: onScroll2,
      ref: refScrollView,
      ScrollComponent: snapToIndices ? ScrollComponent : void 0,
      style
    },
    maintainVisibleContentPosition && /* @__PURE__ */ React2__namespace.createElement(ScrollAdjust, null),
    ENABLE_DEVMODE ? /* @__PURE__ */ React2__namespace.createElement(PaddingDevMode, null) : /* @__PURE__ */ React2__namespace.createElement(Padding, null),
    ListHeaderComponent && /* @__PURE__ */ React2__namespace.createElement(LayoutView, { onLayoutChange: onLayoutHeader, style: ListHeaderComponentStyle }, getComponent(ListHeaderComponent)),
    ListEmptyComponent && getComponent(ListEmptyComponent),
    canRender && !ListEmptyComponent && /* @__PURE__ */ React2__namespace.createElement(
      Containers,
      {
        getRenderedItem: getRenderedItem2,
        horizontal,
        ItemSeparatorComponent,
        recycleItems,
        updateItemSize: updateItemSize2,
        waitForInitialLayout
      }
    ),
    ListFooterComponent && /* @__PURE__ */ React2__namespace.createElement(
      LayoutView,
      {
        onLayoutChange: (layout) => {
          const size = layout[horizontal ? "width" : "height"];
          set$(ctx, "footerSize", size);
        },
        style: ListFooterComponentStyle
      },
      getComponent(ListFooterComponent)
    ),
    __DEV__ && ENABLE_DEVMODE && /* @__PURE__ */ React2__namespace.createElement(DevNumbers, null)
  );
});
var DevNumbers = __DEV__ && React2__namespace.memo(function DevNumbers2() {
  return Array.from({ length: 100 }).map((_, index) => /* @__PURE__ */ React2__namespace.createElement(
    reactNative.View,
    {
      key: index,
      style: {
        height: 100,
        pointerEvents: "none",
        position: "absolute",
        top: index * 100,
        width: "100%"
      }
    },
    /* @__PURE__ */ React2__namespace.createElement(reactNative.Text, { style: { color: "red" } }, index * 100)
  ));
});

// src/utils/getId.ts
function getId(state, index) {
  const { data, keyExtractor } = state.props;
  if (!data) {
    return "";
  }
  const ret = index < data.length ? keyExtractor ? keyExtractor(data[index], index) : index : null;
  const id = ret;
  state.idCache[index] = id;
  return id;
}

// src/core/calculateOffsetForIndex.ts
function calculateOffsetForIndex(ctx, state, index) {
  let position = 0;
  if (index !== void 0) {
    position = (state == null ? void 0 : state.positions.get(getId(state, index))) || 0;
    const paddingTop = peek$(ctx, "stylePaddingTop");
    if (paddingTop) {
      position += paddingTop;
    }
    const headerSize = peek$(ctx, "headerSize");
    if (headerSize) {
      position += headerSize;
    }
  }
  return position;
}

// src/utils/getItemSize.ts
function getItemSize(state, key, index, data, useAverageSize) {
  var _a, _b;
  const {
    sizesKnown,
    sizes,
    scrollingTo,
    averageSizes,
    props: { estimatedItemSize, getEstimatedItemSize, getFixedItemSize, getItemType }
  } = state;
  const sizeKnown = sizesKnown.get(key);
  if (sizeKnown !== void 0) {
    return sizeKnown;
  }
  let size;
  const itemType = getItemType ? (_a = getItemType(data, index)) != null ? _a : "" : "";
  if (getFixedItemSize) {
    size = getFixedItemSize(index, data, itemType);
    if (size !== void 0) {
      sizesKnown.set(key, size);
    }
  }
  if (size === void 0 && useAverageSize && sizeKnown === void 0 && !scrollingTo) {
    const averageSizeForType = (_b = averageSizes[itemType]) == null ? void 0 : _b.avg;
    if (averageSizeForType !== void 0) {
      size = roundSize(averageSizeForType);
    }
  }
  if (size === void 0) {
    size = sizes.get(key);
    if (size !== void 0) {
      return size;
    }
  }
  if (size === void 0) {
    size = getEstimatedItemSize ? getEstimatedItemSize(index, data, itemType) : estimatedItemSize;
  }
  sizes.set(key, size);
  return size;
}

// src/core/calculateOffsetWithOffsetPosition.ts
function calculateOffsetWithOffsetPosition(state, offsetParam, params) {
  const { index, viewOffset, viewPosition } = params;
  let offset = offsetParam;
  if (viewOffset) {
    offset -= viewOffset;
  }
  if (viewPosition !== void 0 && index !== void 0) {
    offset -= viewPosition * (state.scrollLength - getItemSize(state, getId(state, index), index, state.props.data[index]));
  }
  return offset;
}

// src/core/finishScrollTo.ts
var finishScrollTo = (state) => {
  if (state) {
    state.scrollingTo = void 0;
    state.scrollHistory.length = 0;
  }
};

// src/core/scrollTo.ts
function scrollTo(state, params = {}) {
  var _a;
  const { animated, noScrollingTo, isInitialScroll } = params;
  const {
    refScroller,
    props: { horizontal }
  } = state;
  const offset = calculateOffsetWithOffsetPosition(state, params.offset, params);
  state.scrollHistory.length = 0;
  if (!noScrollingTo) {
    state.scrollingTo = params;
  }
  state.scrollPending = offset;
  if (!params.isInitialScroll || reactNative.Platform.OS === "android") {
    (_a = refScroller.current) == null ? void 0 : _a.scrollTo({
      animated: !!animated,
      x: horizontal ? offset : 0,
      y: horizontal ? 0 : offset
    });
  }
  if (!animated) {
    state.scroll = offset;
    setTimeout(() => finishScrollTo(state), 100);
    if (isInitialScroll) {
      setTimeout(() => {
        state.initialScroll = void 0;
      }, 500);
    }
  }
}

// src/utils/requestAdjust.ts
function requestAdjust(ctx, state, positionDiff, dataChanged) {
  if (Math.abs(positionDiff) > 0.1) {
    const needsScrollWorkaround = reactNative.Platform.OS === "android" && !IsNewArchitecture && dataChanged && state.scroll <= positionDiff;
    const doit = () => {
      if (needsScrollWorkaround) {
        scrollTo(state, {
          noScrollingTo: true,
          offset: state.scroll
        });
      } else {
        state.scrollAdjustHandler.requestAdjust(positionDiff);
      }
    };
    state.scroll += positionDiff;
    state.scrollForNextCalculateItemsInView = void 0;
    const didLayout = peek$(ctx, "containersDidLayout");
    if (didLayout) {
      doit();
      const threshold = state.scroll - positionDiff / 2;
      if (!state.ignoreScrollFromMVCP) {
        state.ignoreScrollFromMVCP = {};
      }
      if (positionDiff > 0) {
        state.ignoreScrollFromMVCP.lt = threshold;
      } else {
        state.ignoreScrollFromMVCP.gt = threshold;
      }
      if (state.ignoreScrollFromMVCPTimeout) {
        clearTimeout(state.ignoreScrollFromMVCPTimeout);
      }
      state.ignoreScrollFromMVCPTimeout = setTimeout(
        () => {
          state.ignoreScrollFromMVCP = void 0;
        },
        needsScrollWorkaround ? 250 : 100
      );
    } else {
      requestAnimationFrame(doit);
    }
  }
}

// src/core/mvcp.ts
function prepareMVCP(ctx, state, dataChanged) {
  const {
    idsInView,
    positions,
    scrollingTo,
    props: { maintainVisibleContentPosition }
  } = state;
  let prevPosition;
  let targetId;
  const idsInViewWithPositions = [];
  const scrollTarget = scrollingTo == null ? void 0 : scrollingTo.index;
  if (maintainVisibleContentPosition) {
    const indexByKey = state.indexByKey;
    if (scrollTarget !== void 0) {
      targetId = getId(state, scrollTarget);
    } else if (idsInView.length > 0 && peek$(ctx, "containersDidLayout")) {
      if (dataChanged) {
        for (let i = 0; i < idsInView.length; i++) {
          const id = idsInView[i];
          const index = indexByKey.get(id);
          if (index !== void 0) {
            idsInViewWithPositions.push({ id, position: positions.get(id) });
          }
        }
      } else {
        targetId = state.idsInView.find((id) => indexByKey.get(id) !== void 0);
      }
    }
    if (targetId !== void 0) {
      prevPosition = positions.get(targetId);
    }
  }
  return () => {
    let positionDiff;
    if (dataChanged && targetId === void 0) {
      for (let i = 0; i < idsInViewWithPositions.length; i++) {
        const { id, position } = idsInViewWithPositions[i];
        const newPosition = positions.get(id);
        if (newPosition !== void 0) {
          positionDiff = newPosition - position;
          break;
        }
      }
    }
    if (targetId !== void 0 && prevPosition !== void 0) {
      const newPosition = positions.get(targetId);
      if (newPosition !== void 0) {
        const totalSize = peek$(ctx, "totalSize");
        let diff = newPosition - prevPosition;
        if (diff !== 0 && state.scroll + state.scrollLength > totalSize) {
          if (diff > 0) {
            diff = Math.max(0, totalSize - state.scroll - state.scrollLength);
          } else {
            diff = 0;
          }
        }
        positionDiff = diff;
      }
    }
    if (positionDiff !== void 0 && Math.abs(positionDiff) > 0.1) {
      requestAdjust(ctx, state, positionDiff, dataChanged);
    }
  };
}

// src/core/prepareColumnStartState.ts
function prepareColumnStartState(ctx, state, startIndex, useAverageSize) {
  var _a;
  const numColumns = peek$(ctx, "numColumns");
  let rowStartIndex = startIndex;
  const columnAtStart = state.columns.get(state.idCache[startIndex]);
  if (columnAtStart !== 1) {
    rowStartIndex = findRowStartIndex(state, numColumns, startIndex);
  }
  let currentRowTop = 0;
  const curId = state.idCache[rowStartIndex];
  const column = state.columns.get(curId);
  if (rowStartIndex > 0) {
    const prevIndex = rowStartIndex - 1;
    const prevId = state.idCache[prevIndex];
    const prevPosition = (_a = state.positions.get(prevId)) != null ? _a : 0;
    const prevRowStart = findRowStartIndex(state, numColumns, prevIndex);
    const prevRowHeight = calculateRowMaxSize(state, prevRowStart, prevIndex, useAverageSize);
    currentRowTop = prevPosition + prevRowHeight;
  }
  return {
    column,
    currentRowTop,
    startIndex: rowStartIndex
  };
}
function findRowStartIndex(state, numColumns, index) {
  if (numColumns <= 1) {
    return Math.max(0, index);
  }
  let rowStart = Math.max(0, index);
  while (rowStart > 0) {
    const columnForIndex = state.columns.get(state.idCache[rowStart]);
    if (columnForIndex === 1) {
      break;
    }
    rowStart--;
  }
  return rowStart;
}
function calculateRowMaxSize(state, startIndex, endIndex, useAverageSize) {
  if (endIndex < startIndex) {
    return 0;
  }
  const { data } = state.props;
  if (!data) {
    return 0;
  }
  let maxSize = 0;
  for (let i = startIndex; i <= endIndex; i++) {
    if (i < 0 || i >= data.length) {
      continue;
    }
    const id = state.idCache[i];
    const size = getItemSize(state, id, i, data[i], useAverageSize);
    if (size > maxSize) {
      maxSize = size;
    }
  }
  return maxSize;
}

// src/utils/setPaddingTop.ts
function setPaddingTop(ctx, state, { stylePaddingTop, alignItemsPaddingTop }) {
  if (stylePaddingTop !== void 0) {
    const prevStylePaddingTop = peek$(ctx, "stylePaddingTop") || 0;
    if (stylePaddingTop < prevStylePaddingTop) {
      let prevTotalSize = peek$(ctx, "totalSize") || 0;
      set$(ctx, "totalSize", prevTotalSize + prevStylePaddingTop);
      state.timeoutSetPaddingTop = setTimeout(() => {
        prevTotalSize = peek$(ctx, "totalSize") || 0;
        set$(ctx, "totalSize", prevTotalSize - prevStylePaddingTop);
      }, 16);
    }
    set$(ctx, "stylePaddingTop", stylePaddingTop);
  }
  if (alignItemsPaddingTop !== void 0) {
    set$(ctx, "alignItemsPaddingTop", alignItemsPaddingTop);
  }
}

// src/utils/updateAlignItemsPaddingTop.ts
function updateAlignItemsPaddingTop(ctx, state) {
  const {
    scrollLength,
    props: { alignItemsAtEnd, data }
  } = state;
  if (alignItemsAtEnd) {
    let alignItemsPaddingTop = 0;
    if ((data == null ? void 0 : data.length) > 0) {
      const contentSize = getContentSize(ctx);
      alignItemsPaddingTop = Math.max(0, Math.floor(scrollLength - contentSize));
    }
    setPaddingTop(ctx, state, { alignItemsPaddingTop });
  }
}

// src/core/updateTotalSize.ts
function updateTotalSize(ctx, state) {
  const {
    positions,
    props: { data }
  } = state;
  if (data.length === 0) {
    addTotalSize(ctx, state, null, 0);
  } else {
    const lastId = getId(state, data.length - 1);
    if (lastId !== void 0) {
      const lastPosition = positions.get(lastId);
      if (lastPosition !== void 0) {
        const lastSize = getItemSize(state, lastId, data.length - 1, data[data.length - 1]);
        if (lastSize !== void 0) {
          const totalSize = lastPosition + lastSize;
          addTotalSize(ctx, state, null, totalSize);
        }
      }
    }
  }
}
function addTotalSize(ctx, state, key, add) {
  const { alignItemsAtEnd } = state.props;
  const prevTotalSize = state.totalSize;
  if (key === null) {
    state.totalSize = add;
    if (state.timeoutSetPaddingTop) {
      clearTimeout(state.timeoutSetPaddingTop);
      state.timeoutSetPaddingTop = void 0;
    }
  } else {
    state.totalSize += add;
  }
  if (prevTotalSize !== state.totalSize) {
    set$(ctx, "totalSize", state.totalSize);
    if (alignItemsAtEnd) {
      updateAlignItemsPaddingTop(ctx, state);
    }
  }
}

// src/utils/updateSnapToOffsets.ts
function updateSnapToOffsets(ctx, state) {
  const {
    positions,
    props: { snapToIndices }
  } = state;
  const snapToOffsets = Array(snapToIndices.length);
  for (let i = 0; i < snapToIndices.length; i++) {
    const idx = snapToIndices[i];
    const key = getId(state, idx);
    snapToOffsets[i] = positions.get(key);
  }
  set$(ctx, "snapToOffsets", snapToOffsets);
}

// src/core/updateItemPositions.ts
function updateItemPositions(ctx, state, dataChanged, { startIndex, scrollBottomBuffered } = { scrollBottomBuffered: -1, startIndex: 0 }) {
  var _a, _b, _c, _d;
  const {
    columns,
    indexByKey,
    positions,
    idCache,
    sizesKnown,
    props: { getEstimatedItemSize, snapToIndices, enableAverages }
  } = state;
  const data = state.props.data;
  const dataLength = data.length;
  const numColumns = peek$(ctx, "numColumns");
  const hasColumns = numColumns > 1;
  const indexByKeyForChecking = __DEV__ ? /* @__PURE__ */ new Map() : void 0;
  const maxVisibleArea = scrollBottomBuffered + 1e3;
  const useAverageSize = enableAverages && !getEstimatedItemSize;
  let currentRowTop = 0;
  let column = 1;
  let maxSizeInRow = 0;
  if (startIndex > 0) {
    if (hasColumns) {
      const { startIndex: processedStartIndex, currentRowTop: initialRowTop } = prepareColumnStartState(
        ctx,
        state,
        startIndex,
        useAverageSize
      );
      startIndex = processedStartIndex;
      currentRowTop = initialRowTop;
    } else if (startIndex < dataLength) {
      const prevIndex = startIndex - 1;
      const prevId = getId(state, prevIndex);
      const prevPosition = (_a = positions.get(prevId)) != null ? _a : 0;
      const prevSize = (_b = sizesKnown.get(prevId)) != null ? _b : getItemSize(state, prevId, prevIndex, data[prevIndex], useAverageSize);
      currentRowTop = prevPosition + prevSize;
    }
  }
  const needsIndexByKey = dataChanged || indexByKey.size === 0;
  let didBreakEarly = false;
  let breakAt;
  for (let i = startIndex; i < dataLength; i++) {
    if (breakAt && i > breakAt) {
      didBreakEarly = true;
      break;
    }
    if (breakAt === void 0 && !dataChanged && currentRowTop > maxVisibleArea) {
      const itemsPerRow = hasColumns ? numColumns : 1;
      breakAt = i + itemsPerRow + 10;
    }
    const id = (_c = idCache[i]) != null ? _c : getId(state, i);
    const size = (_d = sizesKnown.get(id)) != null ? _d : getItemSize(state, id, i, data[i], useAverageSize);
    if (__DEV__ && needsIndexByKey) {
      if (indexByKeyForChecking.has(id)) {
        console.error(
          `[legend-list] Error: Detected overlapping key (${id}) which causes missing items and gaps and other terrrible things. Check that keyExtractor returns unique values.`
        );
      }
      indexByKeyForChecking.set(id, i);
    }
    positions.set(id, currentRowTop);
    if (needsIndexByKey) {
      indexByKey.set(id, i);
    }
    columns.set(id, column);
    if (hasColumns) {
      if (size > maxSizeInRow) {
        maxSizeInRow = size;
      }
      column++;
      if (column > numColumns) {
        currentRowTop += maxSizeInRow;
        column = 1;
        maxSizeInRow = 0;
      }
    } else {
      currentRowTop += size;
    }
  }
  if (!didBreakEarly) {
    updateTotalSize(ctx, state);
  }
  if (snapToIndices) {
    updateSnapToOffsets(ctx, state);
  }
}

// src/core/viewability.ts
function ensureViewabilityState(ctx, configId) {
  let map = ctx.mapViewabilityConfigStates;
  if (!map) {
    map = /* @__PURE__ */ new Map();
    ctx.mapViewabilityConfigStates = map;
  }
  let state = map.get(configId);
  if (!state) {
    state = { end: -1, previousEnd: -1, previousStart: -1, start: -1, viewableItems: [] };
    map.set(configId, state);
  }
  return state;
}
function setupViewability(props) {
  let { viewabilityConfig, viewabilityConfigCallbackPairs, onViewableItemsChanged } = props;
  if (viewabilityConfig || onViewableItemsChanged) {
    viewabilityConfigCallbackPairs = [
      ...viewabilityConfigCallbackPairs || [],
      {
        onViewableItemsChanged,
        viewabilityConfig: viewabilityConfig || {
          viewAreaCoveragePercentThreshold: 0
        }
      }
    ];
  }
  return viewabilityConfigCallbackPairs;
}
function updateViewableItems(state, ctx, viewabilityConfigCallbackPairs, scrollSize, start, end) {
  const {
    timeouts,
    props: { data }
  } = state;
  for (const viewabilityConfigCallbackPair of viewabilityConfigCallbackPairs) {
    const viewabilityState = ensureViewabilityState(ctx, viewabilityConfigCallbackPair.viewabilityConfig.id);
    viewabilityState.start = start;
    viewabilityState.end = end;
    if (viewabilityConfigCallbackPair.viewabilityConfig.minimumViewTime) {
      const timer = setTimeout(() => {
        timeouts.delete(timer);
        updateViewableItemsWithConfig(data, viewabilityConfigCallbackPair, state, ctx, scrollSize);
      }, viewabilityConfigCallbackPair.viewabilityConfig.minimumViewTime);
      timeouts.add(timer);
    } else {
      updateViewableItemsWithConfig(data, viewabilityConfigCallbackPair, state, ctx, scrollSize);
    }
  }
}
function updateViewableItemsWithConfig(data, viewabilityConfigCallbackPair, state, ctx, scrollSize) {
  const { viewabilityConfig, onViewableItemsChanged } = viewabilityConfigCallbackPair;
  const configId = viewabilityConfig.id;
  const viewabilityState = ensureViewabilityState(ctx, configId);
  const { viewableItems: previousViewableItems, start, end } = viewabilityState;
  const viewabilityTokens = /* @__PURE__ */ new Map();
  for (const [containerId, value] of ctx.mapViewabilityAmountValues) {
    viewabilityTokens.set(
      containerId,
      computeViewability(
        state,
        ctx,
        viewabilityConfig,
        containerId,
        value.key,
        scrollSize,
        value.item,
        value.index
      )
    );
  }
  const changed = [];
  if (previousViewableItems) {
    for (const viewToken of previousViewableItems) {
      const containerId = findContainerId(ctx, viewToken.key);
      if (!isViewable(
        state,
        ctx,
        viewabilityConfig,
        containerId,
        viewToken.key,
        scrollSize,
        viewToken.item,
        viewToken.index
      )) {
        viewToken.isViewable = false;
        changed.push(viewToken);
      }
    }
  }
  const viewableItems = [];
  for (let i = start; i <= end; i++) {
    const item = data[i];
    if (item) {
      const key = getId(state, i);
      const containerId = findContainerId(ctx, key);
      if (isViewable(state, ctx, viewabilityConfig, containerId, key, scrollSize, item, i)) {
        const viewToken = {
          containerId,
          index: i,
          isViewable: true,
          item,
          key
        };
        viewableItems.push(viewToken);
        if (!(previousViewableItems == null ? void 0 : previousViewableItems.find((v) => v.key === viewToken.key))) {
          changed.push(viewToken);
        }
      }
    }
  }
  Object.assign(viewabilityState, {
    previousEnd: end,
    previousStart: start,
    viewableItems
  });
  if (changed.length > 0) {
    viewabilityState.viewableItems = viewableItems;
    for (let i = 0; i < changed.length; i++) {
      const change = changed[i];
      maybeUpdateViewabilityCallback(ctx, configId, change.containerId, change);
    }
    if (onViewableItemsChanged) {
      onViewableItemsChanged({ changed, viewableItems });
    }
  }
  for (const [containerId, value] of ctx.mapViewabilityAmountValues) {
    if (value.sizeVisible < 0) {
      ctx.mapViewabilityAmountValues.delete(containerId);
    }
  }
}
function shallowEqual(prev, next) {
  if (!prev) return false;
  const keys = Object.keys(next);
  for (let i = 0; i < keys.length; i++) {
    const k = keys[i];
    if (prev[k] !== next[k]) return false;
  }
  return true;
}
function computeViewability(state, ctx, viewabilityConfig, containerId, key, scrollSize, item, index) {
  const { sizes, positions, scroll: scrollState } = state;
  const topPad = (peek$(ctx, "stylePaddingTop") || 0) + (peek$(ctx, "headerSize") || 0);
  const { itemVisiblePercentThreshold, viewAreaCoveragePercentThreshold } = viewabilityConfig;
  const viewAreaMode = viewAreaCoveragePercentThreshold != null;
  const viewablePercentThreshold = viewAreaMode ? viewAreaCoveragePercentThreshold : itemVisiblePercentThreshold;
  const scroll = scrollState - topPad;
  const top = positions.get(key) - scroll;
  const size = sizes.get(key) || 0;
  const bottom = top + size;
  const isEntirelyVisible = top >= 0 && bottom <= scrollSize && bottom > top;
  const sizeVisible = isEntirelyVisible ? size : Math.min(bottom, scrollSize) - Math.max(top, 0);
  const percentVisible = size ? isEntirelyVisible ? 100 : 100 * (sizeVisible / size) : 0;
  const percentOfScroller = size ? 100 * (sizeVisible / scrollSize) : 0;
  const percent = isEntirelyVisible ? 100 : viewAreaMode ? percentOfScroller : percentVisible;
  const isViewable2 = percent >= viewablePercentThreshold;
  const value = {
    containerId,
    index,
    isViewable: isViewable2,
    item,
    key,
    percentOfScroller,
    percentVisible,
    scrollSize,
    size,
    sizeVisible
  };
  const prev = ctx.mapViewabilityAmountValues.get(containerId);
  if (!shallowEqual(prev, value)) {
    ctx.mapViewabilityAmountValues.set(containerId, value);
    const cb = ctx.mapViewabilityAmountCallbacks.get(containerId);
    if (cb) {
      cb(value);
    }
  }
  return value;
}
function isViewable(state, ctx, viewabilityConfig, containerId, key, scrollSize, item, index) {
  const value = ctx.mapViewabilityAmountValues.get(containerId) || computeViewability(state, ctx, viewabilityConfig, containerId, key, scrollSize, item, index);
  return value.isViewable;
}
function findContainerId(ctx, key) {
  const numContainers = peek$(ctx, "numContainers");
  for (let i = 0; i < numContainers; i++) {
    const itemKey = peek$(ctx, `containerItemKey${i}`);
    if (itemKey === key) {
      return i;
    }
  }
  return -1;
}
function maybeUpdateViewabilityCallback(ctx, configId, containerId, viewToken) {
  const key = containerId + configId;
  ctx.mapViewabilityValues.set(key, viewToken);
  const cb = ctx.mapViewabilityCallbacks.get(key);
  cb == null ? void 0 : cb(viewToken);
}
var batchedUpdates = reactNative.unstable_batchedUpdates || ((callback) => callback());

// src/utils/checkAllSizesKnown.ts
function isNullOrUndefined2(value) {
  return value === null || value === void 0;
}
function checkAllSizesKnown(state) {
  const { startBuffered, endBuffered, sizesKnown } = state;
  if (!isNullOrUndefined2(endBuffered) && !isNullOrUndefined2(startBuffered) && startBuffered >= 0 && endBuffered >= 0) {
    let areAllKnown = true;
    for (let i = startBuffered; areAllKnown && i <= endBuffered; i++) {
      const key = getId(state, i);
      areAllKnown && (areAllKnown = sizesKnown.has(key));
    }
    return areAllKnown;
  }
  return false;
}

// src/utils/findAvailableContainers.ts
function findAvailableContainers(ctx, state, numNeeded, startBuffered, endBuffered, pendingRemoval, requiredItemTypes, needNewContainers) {
  const numContainers = peek$(ctx, "numContainers");
  const { stickyContainerPool, containerItemTypes } = state;
  const result = [];
  const availableContainers = [];
  const pendingRemovalSet = new Set(pendingRemoval);
  let pendingRemovalChanged = false;
  const stickyIndicesSet = state.props.stickyIndicesSet;
  const stickyItemIndices = (needNewContainers == null ? void 0 : needNewContainers.filter((index) => stickyIndicesSet.has(index))) || [];
  const canReuseContainer = (containerIndex, requiredType) => {
    if (!requiredType) return true;
    const existingType = containerItemTypes.get(containerIndex);
    if (!existingType) return true;
    return existingType === requiredType;
  };
  const neededTypes = requiredItemTypes ? [...requiredItemTypes] : [];
  let typeIndex = 0;
  for (let i = 0; i < stickyItemIndices.length; i++) {
    const requiredType = neededTypes[typeIndex];
    let foundContainer = false;
    for (const containerIndex of stickyContainerPool) {
      const key = peek$(ctx, `containerItemKey${containerIndex}`);
      const isPendingRemoval = pendingRemovalSet.has(containerIndex);
      if ((key === void 0 || isPendingRemoval) && canReuseContainer(containerIndex, requiredType)) {
        result.push(containerIndex);
        if (isPendingRemoval && pendingRemovalSet.delete(containerIndex)) {
          pendingRemovalChanged = true;
        }
        foundContainer = true;
        if (requiredItemTypes) typeIndex++;
        break;
      }
    }
    if (!foundContainer) {
      const newContainerIndex = numContainers + result.filter((index) => index >= numContainers).length;
      result.push(newContainerIndex);
      stickyContainerPool.add(newContainerIndex);
      if (requiredItemTypes) typeIndex++;
    }
  }
  for (let u = 0; u < numContainers && result.length < numNeeded; u++) {
    if (stickyContainerPool.has(u)) {
      continue;
    }
    const key = peek$(ctx, `containerItemKey${u}`);
    let isOk = key === void 0;
    if (!isOk && pendingRemovalSet.has(u)) {
      pendingRemovalSet.delete(u);
      pendingRemovalChanged = true;
      const requiredType = neededTypes[typeIndex];
      isOk = canReuseContainer(u, requiredType);
    }
    if (isOk) {
      result.push(u);
      if (requiredItemTypes) {
        typeIndex++;
      }
    }
  }
  for (let u = 0; u < numContainers && result.length < numNeeded; u++) {
    if (stickyContainerPool.has(u)) {
      continue;
    }
    const key = peek$(ctx, `containerItemKey${u}`);
    if (key === void 0) continue;
    const index = state.indexByKey.get(key);
    const isOutOfView = index < startBuffered || index > endBuffered;
    if (isOutOfView) {
      const distance = index < startBuffered ? startBuffered - index : index - endBuffered;
      if (!requiredItemTypes || typeIndex < neededTypes.length && canReuseContainer(u, neededTypes[typeIndex])) {
        availableContainers.push({ distance, index: u });
      }
    }
  }
  const remaining = numNeeded - result.length;
  if (remaining > 0) {
    if (availableContainers.length > 0) {
      if (availableContainers.length > remaining) {
        availableContainers.sort(comparatorByDistance);
        availableContainers.length = remaining;
      }
      for (const container of availableContainers) {
        result.push(container.index);
        if (requiredItemTypes) {
          typeIndex++;
        }
      }
    }
    const stillNeeded = numNeeded - result.length;
    if (stillNeeded > 0) {
      for (let i = 0; i < stillNeeded; i++) {
        result.push(numContainers + i);
      }
      if (__DEV__ && numContainers + stillNeeded > peek$(ctx, "numContainersPooled")) {
        console.warn(
          "[legend-list] No unused container available, so creating one on demand. This can be a minor performance issue and is likely caused by the estimatedItemSize being too large. Consider decreasing estimatedItemSize or increasing initialContainerPoolRatio.",
          {
            debugInfo: {
              numContainers,
              numContainersPooled: peek$(ctx, "numContainersPooled"),
              numNeeded,
              stillNeeded
            }
          }
        );
      }
    }
  }
  if (pendingRemovalChanged) {
    pendingRemoval.length = 0;
    for (const value of pendingRemovalSet) {
      pendingRemoval.push(value);
    }
  }
  return result.sort(comparatorDefault);
}
function comparatorByDistance(a, b) {
  return b.distance - a.distance;
}

// src/utils/getScrollVelocity.ts
var getScrollVelocity = (state) => {
  const { scrollHistory } = state;
  let velocity = 0;
  if (scrollHistory.length >= 1) {
    const newest = scrollHistory[scrollHistory.length - 1];
    let oldest;
    let start = 0;
    const now = Date.now();
    for (let i = 0; i < scrollHistory.length - 1; i++) {
      const entry = scrollHistory[i];
      const nextEntry = scrollHistory[i + 1];
      if (i > 0) {
        const prevEntry = scrollHistory[i - 1];
        const prevDirection = entry.scroll - prevEntry.scroll;
        const currentDirection = nextEntry.scroll - entry.scroll;
        if (prevDirection > 0 && currentDirection < 0 || prevDirection < 0 && currentDirection > 0) {
          start = i;
          break;
        }
      }
    }
    for (let i = start; i < scrollHistory.length - 1; i++) {
      const entry = scrollHistory[i];
      if (now - entry.time <= 1e3) {
        oldest = entry;
        break;
      }
    }
    if (oldest && oldest !== newest) {
      const scrollDiff = newest.scroll - oldest.scroll;
      const timeDiff = newest.time - oldest.time;
      velocity = timeDiff > 0 ? scrollDiff / timeDiff : 0;
    }
  }
  return velocity;
};

// src/core/scrollToIndex.ts
function scrollToIndex(ctx, state, { index, viewOffset = 0, animated = true, viewPosition }) {
  if (index >= state.props.data.length) {
    index = state.props.data.length - 1;
  } else if (index < 0) {
    index = 0;
  }
  const firstIndexOffset = calculateOffsetForIndex(ctx, state, index);
  const isLast = index === state.props.data.length - 1;
  if (isLast && viewPosition === void 0) {
    viewPosition = 1;
  }
  state.scrollForNextCalculateItemsInView = void 0;
  scrollTo(state, {
    animated,
    index,
    offset: firstIndexOffset,
    viewOffset,
    viewPosition: viewPosition != null ? viewPosition : 0
  });
}

// src/utils/checkThreshold.ts
var checkThreshold = (distance, atThreshold, threshold, isReached, isBlockedByTimer, onReached, blockTimer) => {
  const distanceAbs = Math.abs(distance);
  const isAtThreshold = atThreshold || distanceAbs < threshold;
  if (!isReached && !isBlockedByTimer) {
    if (isAtThreshold) {
      onReached == null ? void 0 : onReached(distance);
      blockTimer == null ? void 0 : blockTimer(true);
      setTimeout(() => {
        blockTimer == null ? void 0 : blockTimer(false);
      }, 700);
      return true;
    }
  } else {
    if (distance >= 1.3 * threshold) {
      return false;
    }
  }
  return isReached;
};

// src/utils/checkAtBottom.ts
function checkAtBottom(ctx, state) {
  if (!state) {
    return;
  }
  const {
    queuedInitialLayout,
    scrollLength,
    scroll,
    maintainingScrollAtEnd,
    props: { maintainScrollAtEndThreshold, onEndReachedThreshold }
  } = state;
  const contentSize = getContentSize(ctx);
  if (contentSize > 0 && queuedInitialLayout && !maintainingScrollAtEnd) {
    const distanceFromEnd = contentSize - scroll - scrollLength;
    const isContentLess = contentSize < scrollLength;
    state.isAtEnd = isContentLess || distanceFromEnd < scrollLength * maintainScrollAtEndThreshold;
    state.isEndReached = checkThreshold(
      distanceFromEnd,
      isContentLess,
      onEndReachedThreshold * scrollLength,
      state.isEndReached,
      state.endReachedBlockedByTimer,
      (distance) => {
        var _a, _b;
        return (_b = (_a = state.props).onEndReached) == null ? void 0 : _b.call(_a, { distanceFromEnd: distance });
      },
      (block) => {
        state.endReachedBlockedByTimer = block;
      }
    );
  }
}

// src/utils/setDidLayout.ts
function setDidLayout(ctx, state) {
  const {
    loadStartTime,
    initialScroll,
    props: { onLoad }
  } = state;
  state.queuedInitialLayout = true;
  checkAtBottom(ctx, state);
  const setIt = () => {
    set$(ctx, "containersDidLayout", true);
    if (onLoad) {
      onLoad({ elapsedTimeInMs: Date.now() - loadStartTime });
    }
  };
  if (reactNative.Platform.OS === "android" && initialScroll) {
    if (IsNewArchitecture) {
      scrollToIndex(ctx, state, { ...initialScroll, animated: false });
      requestAnimationFrame(() => {
        scrollToIndex(ctx, state, { ...initialScroll, animated: false });
        setIt();
      });
    } else {
      scrollToIndex(ctx, state, { ...initialScroll, animated: false });
      setIt();
    }
  } else {
    setIt();
  }
}

// src/core/calculateItemsInView.ts
function findCurrentStickyIndex(stickyArray, scroll, state) {
  var _a;
  const idCache = state.idCache;
  const positions = state.positions;
  for (let i = stickyArray.length - 1; i >= 0; i--) {
    const stickyIndex = stickyArray[i];
    const stickyId = (_a = idCache[stickyIndex]) != null ? _a : getId(state, stickyIndex);
    const stickyPos = stickyId ? positions.get(stickyId) : void 0;
    if (stickyPos !== void 0 && scroll >= stickyPos) {
      return i;
    }
  }
  return -1;
}
function getActiveStickyIndices(ctx, state, stickyIndices) {
  return new Set(
    Array.from(state.stickyContainerPool).map((i) => peek$(ctx, `containerItemKey${i}`)).map((key) => key ? state.indexByKey.get(key) : void 0).filter((idx) => idx !== void 0 && stickyIndices.has(idx))
  );
}
function handleStickyActivation(ctx, state, stickyIndices, stickyArray, currentStickyIdx, needNewContainers, startBuffered, endBuffered) {
  var _a;
  const activeIndices = getActiveStickyIndices(ctx, state, stickyIndices);
  state.activeStickyIndex = currentStickyIdx >= 0 ? stickyArray[currentStickyIdx] : void 0;
  for (let offset = 0; offset <= 1; offset++) {
    const idx = currentStickyIdx - offset;
    if (idx < 0 || activeIndices.has(stickyArray[idx])) continue;
    const stickyIndex = stickyArray[idx];
    const stickyId = (_a = state.idCache[stickyIndex]) != null ? _a : getId(state, stickyIndex);
    if (stickyId && !state.containerItemKeys.has(stickyId) && (stickyIndex < startBuffered || stickyIndex > endBuffered)) {
      needNewContainers.push(stickyIndex);
    }
  }
}
function handleStickyRecycling(ctx, state, stickyArray, scroll, scrollBuffer, currentStickyIdx, pendingRemoval) {
  var _a, _b, _c;
  for (const containerIndex of state.stickyContainerPool) {
    const itemKey = peek$(ctx, `containerItemKey${containerIndex}`);
    const itemIndex = itemKey ? state.indexByKey.get(itemKey) : void 0;
    if (itemIndex === void 0) continue;
    const arrayIdx = stickyArray.indexOf(itemIndex);
    if (arrayIdx === -1) {
      state.stickyContainerPool.delete(containerIndex);
      set$(ctx, `containerSticky${containerIndex}`, false);
      set$(ctx, `containerStickyOffset${containerIndex}`, void 0);
      continue;
    }
    const isRecentSticky = arrayIdx >= currentStickyIdx - 1 && arrayIdx <= currentStickyIdx + 1;
    if (isRecentSticky) continue;
    const nextIndex = stickyArray[arrayIdx + 1];
    let shouldRecycle = false;
    if (nextIndex) {
      const nextId = (_a = state.idCache[nextIndex]) != null ? _a : getId(state, nextIndex);
      const nextPos = nextId ? state.positions.get(nextId) : void 0;
      shouldRecycle = nextPos !== void 0 && scroll > nextPos + scrollBuffer * 2;
    } else {
      const currentId = (_b = state.idCache[itemIndex]) != null ? _b : getId(state, itemIndex);
      if (currentId) {
        const currentPos = state.positions.get(currentId);
        const currentSize = (_c = state.sizes.get(currentId)) != null ? _c : getItemSize(state, currentId, itemIndex, state.props.data[itemIndex]);
        shouldRecycle = currentPos !== void 0 && scroll > currentPos + currentSize + scrollBuffer * 3;
      }
    }
    if (shouldRecycle) {
      pendingRemoval.push(containerIndex);
    }
  }
}
function calculateItemsInView(ctx, state, params = {}) {
  batchedUpdates(() => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i;
    const {
      columns,
      containerItemKeys,
      enableScrollForNextCalculateItemsInView,
      idCache,
      indexByKey,
      minIndexSizeChanged,
      positions,
      scrollForNextCalculateItemsInView,
      scrollLength,
      sizes,
      startBufferedId: startBufferedIdOrig,
      viewabilityConfigCallbackPairs,
      props: { getItemType, initialScroll, itemsAreEqual, keyExtractor, onStickyHeaderChange, scrollBuffer }
    } = state;
    const { data } = state.props;
    const stickyIndicesArr = state.props.stickyIndicesArr || [];
    const stickyIndicesSet = state.props.stickyIndicesSet || /* @__PURE__ */ new Set();
    const prevNumContainers = peek$(ctx, "numContainers");
    if (!data || scrollLength === 0 || !prevNumContainers) {
      return;
    }
    const totalSize = peek$(ctx, "totalSize");
    const topPad = peek$(ctx, "stylePaddingTop") + peek$(ctx, "headerSize");
    const numColumns = peek$(ctx, "numColumns");
    const { dataChanged, doMVCP } = params;
    const speed = getScrollVelocity(state);
    const scrollExtra = 0;
    const { queuedInitialLayout } = state;
    let { scroll: scrollState } = state;
    if (!queuedInitialLayout && initialScroll) {
      const updatedOffset = calculateOffsetWithOffsetPosition(
        state,
        calculateOffsetForIndex(ctx, state, initialScroll.index),
        initialScroll
      );
      scrollState = updatedOffset;
    }
    const scrollAdjustPad = -topPad;
    let scroll = scrollState + scrollExtra + scrollAdjustPad;
    if (scroll + scrollLength > totalSize) {
      scroll = Math.max(0, totalSize - scrollLength);
    }
    if (ENABLE_DEBUG_VIEW) {
      set$(ctx, "debugRawScroll", scrollState);
      set$(ctx, "debugComputedScroll", scroll);
    }
    const previousStickyIndex = state.activeStickyIndex;
    const currentStickyIdx = stickyIndicesArr.length > 0 ? findCurrentStickyIndex(stickyIndicesArr, scroll, state) : -1;
    const nextActiveStickyIndex = currentStickyIdx >= 0 ? stickyIndicesArr[currentStickyIdx] : void 0;
    state.activeStickyIndex = nextActiveStickyIndex;
    let scrollBufferTop = scrollBuffer;
    let scrollBufferBottom = scrollBuffer;
    if (speed > 0 || speed === 0 && scroll < Math.max(50, scrollBuffer)) {
      scrollBufferTop = scrollBuffer * 0.5;
      scrollBufferBottom = scrollBuffer * 1.5;
    } else {
      scrollBufferTop = scrollBuffer * 1.5;
      scrollBufferBottom = scrollBuffer * 0.5;
    }
    const scrollTopBuffered = scroll - scrollBufferTop;
    const scrollBottom = scroll + scrollLength + (scroll < 0 ? -scroll : 0);
    const scrollBottomBuffered = scrollBottom + scrollBufferBottom;
    if (!dataChanged && scrollForNextCalculateItemsInView) {
      const { top, bottom } = scrollForNextCalculateItemsInView;
      if (scrollTopBuffered > top && scrollBottomBuffered < bottom) {
        return;
      }
    }
    const checkMVCP = doMVCP ? prepareMVCP(ctx, state, dataChanged) : void 0;
    if (dataChanged) {
      indexByKey.clear();
      idCache.length = 0;
      positions.clear();
    }
    const startIndex = dataChanged ? 0 : (_a = minIndexSizeChanged != null ? minIndexSizeChanged : state.startBuffered) != null ? _a : 0;
    updateItemPositions(ctx, state, dataChanged, { scrollBottomBuffered, startIndex });
    if (minIndexSizeChanged !== void 0) {
      state.minIndexSizeChanged = void 0;
    }
    checkMVCP == null ? void 0 : checkMVCP();
    let startNoBuffer = null;
    let startBuffered = null;
    let startBufferedId = null;
    let endNoBuffer = null;
    let endBuffered = null;
    let loopStart = !dataChanged && startBufferedIdOrig ? indexByKey.get(startBufferedIdOrig) || 0 : 0;
    for (let i = loopStart; i >= 0; i--) {
      const id = (_b = idCache[i]) != null ? _b : getId(state, i);
      const top = positions.get(id);
      const size = (_c = sizes.get(id)) != null ? _c : getItemSize(state, id, i, data[i]);
      const bottom = top + size;
      if (bottom > scroll - scrollBuffer) {
        loopStart = i;
      } else {
        break;
      }
    }
    const loopStartMod = loopStart % numColumns;
    if (loopStartMod > 0) {
      loopStart -= loopStartMod;
    }
    let foundEnd = false;
    let nextTop;
    let nextBottom;
    let maxIndexRendered = 0;
    for (let i = 0; i < prevNumContainers; i++) {
      const key = peek$(ctx, `containerItemKey${i}`);
      if (key !== void 0) {
        const index = indexByKey.get(key);
        maxIndexRendered = Math.max(maxIndexRendered, index);
      }
    }
    let firstFullyOnScreenIndex;
    const dataLength = data.length;
    for (let i = Math.max(0, loopStart); i < dataLength && (!foundEnd || i <= maxIndexRendered); i++) {
      const id = (_d = idCache[i]) != null ? _d : getId(state, i);
      const size = (_e = sizes.get(id)) != null ? _e : getItemSize(state, id, i, data[i]);
      const top = positions.get(id);
      if (!foundEnd) {
        if (startNoBuffer === null && top + size > scroll) {
          startNoBuffer = i;
        }
        if (firstFullyOnScreenIndex === void 0 && top >= scroll - 10) {
          firstFullyOnScreenIndex = i;
        }
        if (startBuffered === null && top + size > scrollTopBuffered) {
          startBuffered = i;
          startBufferedId = id;
          nextTop = top;
        }
        if (startNoBuffer !== null) {
          if (top <= scrollBottom) {
            endNoBuffer = i;
          }
          if (top <= scrollBottomBuffered) {
            endBuffered = i;
            nextBottom = top + size;
          } else {
            foundEnd = true;
          }
        }
      }
    }
    const idsInView = [];
    for (let i = firstFullyOnScreenIndex; i <= endNoBuffer; i++) {
      const id = (_f = idCache[i]) != null ? _f : getId(state, i);
      idsInView.push(id);
    }
    Object.assign(state, {
      endBuffered,
      endNoBuffer,
      firstFullyOnScreenIndex,
      idsInView,
      startBuffered,
      startBufferedId,
      startNoBuffer
    });
    if (enableScrollForNextCalculateItemsInView && nextTop !== void 0 && nextBottom !== void 0) {
      state.scrollForNextCalculateItemsInView = nextTop !== void 0 && nextBottom !== void 0 ? {
        bottom: nextBottom,
        top: nextTop
      } : void 0;
    }
    const numContainers = peek$(ctx, "numContainers");
    const pendingRemoval = [];
    if (dataChanged) {
      for (let i = 0; i < numContainers; i++) {
        const itemKey = peek$(ctx, `containerItemKey${i}`);
        if (!keyExtractor || itemKey && indexByKey.get(itemKey) === void 0) {
          pendingRemoval.push(i);
        }
      }
    }
    if (startBuffered !== null && endBuffered !== null) {
      let numContainers2 = prevNumContainers;
      const needNewContainers = [];
      for (let i = startBuffered; i <= endBuffered; i++) {
        const id = (_g = idCache[i]) != null ? _g : getId(state, i);
        if (!containerItemKeys.has(id)) {
          needNewContainers.push(i);
        }
      }
      if (stickyIndicesArr.length > 0) {
        handleStickyActivation(
          ctx,
          state,
          stickyIndicesSet,
          stickyIndicesArr,
          currentStickyIdx,
          needNewContainers,
          startBuffered,
          endBuffered
        );
      } else {
        state.activeStickyIndex = void 0;
      }
      if (needNewContainers.length > 0) {
        const requiredItemTypes = getItemType ? needNewContainers.map((i) => {
          const itemType = getItemType(data[i], i);
          return itemType ? String(itemType) : "";
        }) : void 0;
        const availableContainers = findAvailableContainers(
          ctx,
          state,
          needNewContainers.length,
          startBuffered,
          endBuffered,
          pendingRemoval,
          requiredItemTypes,
          needNewContainers
        );
        for (let idx = 0; idx < needNewContainers.length; idx++) {
          const i = needNewContainers[idx];
          const containerIndex = availableContainers[idx];
          const id = (_h = idCache[i]) != null ? _h : getId(state, i);
          const oldKey = peek$(ctx, `containerItemKey${containerIndex}`);
          if (oldKey && oldKey !== id) {
            containerItemKeys.delete(oldKey);
          }
          set$(ctx, `containerItemKey${containerIndex}`, id);
          set$(ctx, `containerItemData${containerIndex}`, data[i]);
          if (requiredItemTypes) {
            state.containerItemTypes.set(containerIndex, requiredItemTypes[idx]);
          }
          containerItemKeys.add(id);
          if (stickyIndicesSet.has(i)) {
            set$(ctx, `containerSticky${containerIndex}`, true);
            const topPadding = (peek$(ctx, "stylePaddingTop") || 0) + (peek$(ctx, "headerSize") || 0);
            set$(ctx, `containerStickyOffset${containerIndex}`, topPadding);
            state.stickyContainerPool.add(containerIndex);
          } else {
            set$(ctx, `containerSticky${containerIndex}`, false);
            state.stickyContainerPool.delete(containerIndex);
          }
          if (containerIndex >= numContainers2) {
            numContainers2 = containerIndex + 1;
          }
        }
        if (numContainers2 !== prevNumContainers) {
          set$(ctx, "numContainers", numContainers2);
          if (numContainers2 > peek$(ctx, "numContainersPooled")) {
            set$(ctx, "numContainersPooled", Math.ceil(numContainers2 * 1.5));
          }
        }
      }
    }
    if (stickyIndicesArr.length > 0) {
      handleStickyRecycling(ctx, state, stickyIndicesArr, scroll, scrollBuffer, currentStickyIdx, pendingRemoval);
    }
    for (let i = 0; i < numContainers; i++) {
      const itemKey = peek$(ctx, `containerItemKey${i}`);
      if (pendingRemoval.includes(i)) {
        if (itemKey) {
          containerItemKeys.delete(itemKey);
        }
        state.containerItemTypes.delete(i);
        if (state.stickyContainerPool.has(i)) {
          set$(ctx, `containerSticky${i}`, false);
          set$(ctx, `containerStickyOffset${i}`, void 0);
          state.stickyContainerPool.delete(i);
        }
        set$(ctx, `containerItemKey${i}`, void 0);
        set$(ctx, `containerItemData${i}`, void 0);
        set$(ctx, `containerPosition${i}`, POSITION_OUT_OF_VIEW);
        set$(ctx, `containerColumn${i}`, -1);
      } else {
        const itemIndex = indexByKey.get(itemKey);
        const item = data[itemIndex];
        if (item !== void 0) {
          const id = (_i = idCache[itemIndex]) != null ? _i : getId(state, itemIndex);
          const position = positions.get(id);
          if (position === void 0) {
            set$(ctx, `containerPosition${i}`, POSITION_OUT_OF_VIEW);
          } else {
            const column = columns.get(id) || 1;
            const prevPos = peek$(ctx, `containerPosition${i}`);
            const prevColumn = peek$(ctx, `containerColumn${i}`);
            const prevData = peek$(ctx, `containerItemData${i}`);
            if (position > POSITION_OUT_OF_VIEW && position !== prevPos) {
              set$(ctx, `containerPosition${i}`, position);
            }
            if (column >= 0 && column !== prevColumn) {
              set$(ctx, `containerColumn${i}`, column);
            }
            if (prevData !== item && (itemsAreEqual ? !itemsAreEqual(prevData, item, itemIndex, data) : true)) {
              set$(ctx, `containerItemData${i}`, item);
            }
          }
        }
      }
    }
    if (!queuedInitialLayout && endBuffered !== null) {
      if (checkAllSizesKnown(state)) {
        setDidLayout(ctx, state);
      }
    }
    if (viewabilityConfigCallbackPairs) {
      updateViewableItems(state, ctx, viewabilityConfigCallbackPairs, scrollLength, startNoBuffer, endNoBuffer);
    }
    if (onStickyHeaderChange && stickyIndicesArr.length > 0 && nextActiveStickyIndex !== void 0 && nextActiveStickyIndex !== previousStickyIndex) {
      const item = data[nextActiveStickyIndex];
      if (item !== void 0) {
        onStickyHeaderChange({ index: nextActiveStickyIndex, item });
      }
    }
  });
}

// src/core/doMaintainScrollAtEnd.ts
function doMaintainScrollAtEnd(ctx, state, animated) {
  const {
    refScroller,
    props: { maintainScrollAtEnd }
  } = state;
  if ((state == null ? void 0 : state.isAtEnd) && maintainScrollAtEnd && peek$(ctx, "containersDidLayout")) {
    const paddingTop = peek$(ctx, "alignItemsPaddingTop");
    if (paddingTop > 0) {
      state.scroll = 0;
    }
    requestAnimationFrame(() => {
      var _a;
      if (state == null ? void 0 : state.isAtEnd) {
        state.maintainingScrollAtEnd = true;
        (_a = refScroller.current) == null ? void 0 : _a.scrollToEnd({
          animated
        });
        setTimeout(
          () => {
            state.maintainingScrollAtEnd = false;
          },
          0
        );
      }
    });
    return true;
  }
}

// src/utils/checkAtTop.ts
function checkAtTop(state) {
  if (!state) {
    return;
  }
  const {
    scrollLength,
    scroll,
    props: { onStartReachedThreshold }
  } = state;
  const distanceFromTop = scroll;
  state.isAtStart = distanceFromTop <= 0;
  state.isStartReached = checkThreshold(
    distanceFromTop,
    false,
    onStartReachedThreshold * scrollLength,
    state.isStartReached,
    state.startReachedBlockedByTimer,
    (distance) => {
      var _a, _b;
      return (_b = (_a = state.props).onStartReached) == null ? void 0 : _b.call(_a, { distanceFromStart: distance });
    },
    (block) => {
      state.startReachedBlockedByTimer = block;
    }
  );
}

// src/utils/updateAveragesOnDataChange.ts
function updateAveragesOnDataChange(state, oldData, newData) {
  var _a;
  const {
    averageSizes,
    sizesKnown,
    indexByKey,
    props: { itemsAreEqual, getItemType, keyExtractor }
  } = state;
  if (!itemsAreEqual || !oldData.length || !newData.length) {
    for (const key in averageSizes) {
      delete averageSizes[key];
    }
    return;
  }
  const itemTypesToPreserve = {};
  const newDataLength = newData.length;
  const oldDataLength = oldData.length;
  for (let newIndex = 0; newIndex < newDataLength; newIndex++) {
    const newItem = newData[newIndex];
    const id = keyExtractor ? keyExtractor(newItem, newIndex) : String(newIndex);
    const oldIndex = indexByKey.get(id);
    if (oldIndex !== void 0 && oldIndex < oldDataLength) {
      const knownSize = sizesKnown.get(id);
      if (knownSize === void 0) continue;
      const oldItem = oldData[oldIndex];
      const areEqual = itemsAreEqual(oldItem, newItem, newIndex, newData);
      if (areEqual) {
        const itemType = getItemType ? (_a = getItemType(newItem, newIndex)) != null ? _a : "" : "";
        let typeData = itemTypesToPreserve[itemType];
        if (!typeData) {
          typeData = itemTypesToPreserve[itemType] = { count: 0, totalSize: 0 };
        }
        typeData.totalSize += knownSize;
        typeData.count++;
      }
    }
  }
  for (const key in averageSizes) {
    delete averageSizes[key];
  }
  for (const itemType in itemTypesToPreserve) {
    const { totalSize, count } = itemTypesToPreserve[itemType];
    if (count > 0) {
      averageSizes[itemType] = {
        avg: totalSize / count,
        num: count
      };
    }
  }
}

// src/core/checkResetContainers.ts
function checkResetContainers(ctx, state, isFirst, dataProp) {
  if (state) {
    if (!isFirst && state.props.data !== dataProp) {
      updateAveragesOnDataChange(state, state.props.data, dataProp);
    }
    const { maintainScrollAtEnd } = state.props;
    if (!isFirst) {
      calculateItemsInView(ctx, state, { dataChanged: true, doMVCP: true });
      const shouldMaintainScrollAtEnd = maintainScrollAtEnd === true || maintainScrollAtEnd.onDataChange;
      const didMaintainScrollAtEnd = shouldMaintainScrollAtEnd && doMaintainScrollAtEnd(ctx, state, false);
      if (!didMaintainScrollAtEnd && dataProp.length > state.props.data.length) {
        state.isEndReached = false;
      }
      if (!didMaintainScrollAtEnd) {
        checkAtTop(state);
        checkAtBottom(ctx, state);
      }
    }
  }
}

// src/core/doInitialAllocateContainers.ts
function doInitialAllocateContainers(ctx, state) {
  var _a, _b, _c;
  const {
    scrollLength,
    props: {
      data,
      getEstimatedItemSize,
      getFixedItemSize,
      getItemType,
      scrollBuffer,
      numColumns,
      estimatedItemSize
    }
  } = state;
  const hasContainers = peek$(ctx, "numContainers");
  if (scrollLength > 0 && data.length > 0 && !hasContainers) {
    let averageItemSize;
    if (getFixedItemSize || getEstimatedItemSize) {
      let totalSize = 0;
      const num = Math.min(20, data.length);
      for (let i = 0; i < num; i++) {
        const item = data[i];
        const itemType = getItemType ? (_a = getItemType(item, i)) != null ? _a : "" : "";
        totalSize += (_c = (_b = getFixedItemSize == null ? void 0 : getFixedItemSize(i, item, itemType)) != null ? _b : getEstimatedItemSize == null ? void 0 : getEstimatedItemSize(i, item, itemType)) != null ? _c : estimatedItemSize;
      }
      averageItemSize = totalSize / num;
    } else {
      averageItemSize = estimatedItemSize;
    }
    const numContainers = Math.ceil((scrollLength + scrollBuffer * 2) / averageItemSize * numColumns);
    for (let i = 0; i < numContainers; i++) {
      set$(ctx, `containerPosition${i}`, POSITION_OUT_OF_VIEW);
      set$(ctx, `containerColumn${i}`, -1);
    }
    set$(ctx, "numContainers", numContainers);
    set$(ctx, "numContainersPooled", numContainers * state.props.initialContainerPoolRatio);
    if (!IsNewArchitecture || state.lastLayout) {
      if (state.props.initialScroll) {
        requestAnimationFrame(() => {
          calculateItemsInView(ctx, state, { dataChanged: true, doMVCP: true });
        });
      } else {
        calculateItemsInView(ctx, state, { dataChanged: true, doMVCP: true });
      }
    }
    return true;
  }
}

// src/core/handleLayout.ts
function handleLayout(ctx, state, layout, setCanRender) {
  const { maintainScrollAtEnd } = state.props;
  const measuredLength = layout[state.props.horizontal ? "width" : "height"];
  const previousLength = state.scrollLength;
  const scrollLength = measuredLength > 0 ? measuredLength : previousLength;
  const otherAxisSize = layout[state.props.horizontal ? "height" : "width"];
  const needsCalculate = !state.lastLayout || scrollLength > state.scrollLength || state.lastLayout.x !== layout.x || state.lastLayout.y !== layout.y;
  state.lastLayout = layout;
  const prevOtherAxisSize = state.otherAxisSize;
  const didChange = scrollLength !== state.scrollLength || otherAxisSize !== prevOtherAxisSize;
  if (didChange) {
    state.scrollLength = scrollLength;
    state.otherAxisSize = otherAxisSize;
    state.lastBatchingAction = Date.now();
    state.scrollForNextCalculateItemsInView = void 0;
    if (scrollLength > 0) {
      doInitialAllocateContainers(ctx, state);
    }
    if (needsCalculate) {
      calculateItemsInView(ctx, state, { doMVCP: true });
    }
    if (didChange || otherAxisSize !== prevOtherAxisSize) {
      set$(ctx, "scrollSize", { height: layout.height, width: layout.width });
    }
    if (maintainScrollAtEnd === true || maintainScrollAtEnd.onLayout) {
      doMaintainScrollAtEnd(ctx, state, false);
    }
    updateAlignItemsPaddingTop(ctx, state);
    checkAtBottom(ctx, state);
    checkAtTop(state);
    if (state) {
      state.needsOtherAxisSize = otherAxisSize - (state.props.stylePaddingTop || 0) < 10;
    }
    if (__DEV__ && measuredLength === 0) {
      warnDevOnce(
        "height0",
        `List ${state.props.horizontal ? "width" : "height"} is 0. You may need to set a style or \`flex: \` for the list, because children are absolutely positioned.`
      );
    }
  }
  setCanRender(true);
}

// src/core/onScroll.ts
function onScroll(ctx, state, event) {
  var _a, _b, _c;
  const {
    scrollProcessingEnabled,
    props: { onScroll: onScrollProp }
  } = state;
  if (scrollProcessingEnabled === false) {
    return;
  }
  if (((_b = (_a = event.nativeEvent) == null ? void 0 : _a.contentSize) == null ? void 0 : _b.height) === 0 && ((_c = event.nativeEvent.contentSize) == null ? void 0 : _c.width) === 0) {
    return;
  }
  const newScroll = event.nativeEvent.contentOffset[state.props.horizontal ? "x" : "y"];
  state.scrollPending = newScroll;
  updateScroll(ctx, state, newScroll);
  onScrollProp == null ? void 0 : onScrollProp(event);
}
function updateScroll(ctx, state, newScroll) {
  const scrollingTo = state.scrollingTo;
  state.hasScrolled = true;
  state.lastBatchingAction = Date.now();
  const currentTime = Date.now();
  const adjust = state.scrollAdjustHandler.getAdjust();
  const lastHistoryAdjust = state.lastScrollAdjustForHistory;
  const adjustChanged = lastHistoryAdjust !== void 0 && Math.abs(adjust - lastHistoryAdjust) > 0.1;
  if (adjustChanged) {
    state.scrollHistory.length = 0;
  }
  state.lastScrollAdjustForHistory = adjust;
  if (scrollingTo === void 0 && !(state.scrollHistory.length === 0 && newScroll === state.scroll)) {
    if (!adjustChanged) {
      state.scrollHistory.push({ scroll: newScroll, time: currentTime });
    }
  }
  if (state.scrollHistory.length > 5) {
    state.scrollHistory.shift();
  }
  state.scrollPrev = state.scroll;
  state.scrollPrevTime = state.scrollTime;
  state.scroll = newScroll;
  state.scrollTime = currentTime;
  const ignoreScrollFromMVCP = state.ignoreScrollFromMVCP;
  if (ignoreScrollFromMVCP && !state.scrollingTo) {
    const { lt, gt } = ignoreScrollFromMVCP;
    if (lt && newScroll < lt || gt && newScroll > gt) {
      return;
    }
  }
  if (state.dataChangeNeedsScrollUpdate || Math.abs(state.scroll - state.scrollPrev) > 2) {
    calculateItemsInView(ctx, state, { doMVCP: state.scrollingTo !== void 0 });
    checkAtBottom(ctx, state);
    checkAtTop(state);
    state.dataChangeNeedsScrollUpdate = false;
  }
}

// src/core/ScrollAdjustHandler.ts
var ScrollAdjustHandler = class {
  constructor(ctx) {
    this.appliedAdjust = 0;
    this.mounted = false;
    this.context = ctx;
  }
  requestAdjust(add) {
    const oldAdjustTop = this.appliedAdjust;
    this.appliedAdjust = add + oldAdjustTop;
    const set = () => set$(this.context, "scrollAdjust", this.appliedAdjust);
    if (this.mounted) {
      set();
    } else {
      requestAnimationFrame(set);
    }
  }
  setMounted() {
    this.mounted = true;
  }
  getAdjust() {
    return this.appliedAdjust;
  }
};

// src/core/updateItemSize.ts
function updateItemSize(ctx, state, itemKey, sizeObj) {
  var _a;
  const {
    sizesKnown,
    props: {
      getFixedItemSize,
      getItemType,
      horizontal,
      suggestEstimatedItemSize,
      onItemSizeChanged,
      data,
      maintainScrollAtEnd
    }
  } = state;
  if (!data) return;
  const index = state.indexByKey.get(itemKey);
  if (getFixedItemSize) {
    if (index === void 0) {
      return;
    }
    const itemData = state.props.data[index];
    if (itemData === void 0) {
      return;
    }
    const type = getItemType ? (_a = getItemType(itemData, index)) != null ? _a : "" : "";
    const size2 = getFixedItemSize(index, itemData, type);
    if (size2 !== void 0 && size2 === sizesKnown.get(itemKey)) {
      return;
    }
  }
  const containersDidLayout = peek$(ctx, "containersDidLayout");
  let needsRecalculate = !containersDidLayout;
  let shouldMaintainScrollAtEnd = false;
  let minIndexSizeChanged;
  let maxOtherAxisSize = peek$(ctx, "otherAxisSize") || 0;
  const prevSizeKnown = state.sizesKnown.get(itemKey);
  const diff = updateOneItemSize(state, itemKey, sizeObj);
  const size = Math.floor((horizontal ? sizeObj.width : sizeObj.height) * 8) / 8;
  if (diff !== 0) {
    minIndexSizeChanged = minIndexSizeChanged !== void 0 ? Math.min(minIndexSizeChanged, index) : index;
    const { startBuffered, endBuffered } = state;
    needsRecalculate || (needsRecalculate = index >= startBuffered && index <= endBuffered);
    if (!needsRecalculate) {
      const numContainers = ctx.values.get("numContainers");
      for (let i = 0; i < numContainers; i++) {
        if (peek$(ctx, `containerItemKey${i}`) === itemKey) {
          needsRecalculate = true;
          break;
        }
      }
    }
    if (state.needsOtherAxisSize) {
      const otherAxisSize = horizontal ? sizeObj.height : sizeObj.width;
      maxOtherAxisSize = Math.max(maxOtherAxisSize, otherAxisSize);
    }
    if (prevSizeKnown !== void 0 && Math.abs(prevSizeKnown - size) > 5) {
      shouldMaintainScrollAtEnd = true;
    }
    addTotalSize(ctx, state, itemKey, diff);
    onItemSizeChanged == null ? void 0 : onItemSizeChanged({
      index,
      itemData: state.props.data[index],
      itemKey,
      previous: size - diff,
      size
    });
  }
  if (minIndexSizeChanged !== void 0) {
    state.minIndexSizeChanged = state.minIndexSizeChanged !== void 0 ? Math.min(state.minIndexSizeChanged, minIndexSizeChanged) : minIndexSizeChanged;
  }
  if (__DEV__ && suggestEstimatedItemSize && minIndexSizeChanged !== void 0) {
    if (state.timeoutSizeMessage) clearTimeout(state.timeoutSizeMessage);
    state.timeoutSizeMessage = setTimeout(() => {
      var _a2;
      state.timeoutSizeMessage = void 0;
      const num = state.sizesKnown.size;
      const avg = (_a2 = state.averageSizes[""]) == null ? void 0 : _a2.avg;
      console.warn(
        `[legend-list] Based on the ${num} items rendered so far, the optimal estimated size is ${avg}.`
      );
    }, 1e3);
  }
  const cur = peek$(ctx, "otherAxisSize");
  if (!cur || maxOtherAxisSize > cur) {
    set$(ctx, "otherAxisSize", maxOtherAxisSize);
  }
  if (containersDidLayout || checkAllSizesKnown(state)) {
    if (needsRecalculate) {
      state.scrollForNextCalculateItemsInView = void 0;
      calculateItemsInView(ctx, state, { doMVCP: true });
    }
    if (shouldMaintainScrollAtEnd) {
      if (maintainScrollAtEnd === true || maintainScrollAtEnd.onItemLayout) {
        doMaintainScrollAtEnd(ctx, state, false);
      }
    }
  }
}
function updateOneItemSize(state, itemKey, sizeObj) {
  var _a;
  const {
    sizes,
    indexByKey,
    sizesKnown,
    averageSizes,
    props: { data, horizontal, getEstimatedItemSize, getItemType, getFixedItemSize }
  } = state;
  if (!data) return 0;
  const index = indexByKey.get(itemKey);
  const prevSize = getItemSize(state, itemKey, index, data[index]);
  const size = Math.floor((horizontal ? sizeObj.width : sizeObj.height) * 8) / 8;
  sizesKnown.set(itemKey, size);
  if (!getEstimatedItemSize && !getFixedItemSize && size > 0) {
    const itemType = getItemType ? (_a = getItemType(data[index], index)) != null ? _a : "" : "";
    let averages = averageSizes[itemType];
    if (!averages) {
      averages = averageSizes[itemType] = { avg: 0, num: 0 };
    }
    averages.avg = (averages.avg * averages.num + size) / (averages.num + 1);
    averages.num++;
  }
  if (!prevSize || Math.abs(prevSize - size) > 0.1) {
    sizes.set(itemKey, size);
    return size - prevSize;
  }
  return 0;
}
var useCombinedRef = (...refs) => {
  const callback = React2.useCallback((element) => {
    for (const ref of refs) {
      if (!ref) {
        continue;
      }
      if (isFunction(ref)) {
        ref(element);
      } else {
        ref.current = element;
      }
    }
  }, refs);
  return callback;
};

// src/utils/createColumnWrapperStyle.ts
function createColumnWrapperStyle(contentContainerStyle) {
  const { gap, columnGap, rowGap } = contentContainerStyle;
  if (gap || columnGap || rowGap) {
    contentContainerStyle.gap = void 0;
    contentContainerStyle.columnGap = void 0;
    contentContainerStyle.rowGap = void 0;
    return {
      columnGap,
      gap,
      rowGap
    };
  }
}
function getRenderedItem(ctx, state, key) {
  var _a;
  if (!state) {
    return null;
  }
  const {
    indexByKey,
    props: { data, getItemType, renderItem }
  } = state;
  const index = indexByKey.get(key);
  if (index === void 0) {
    return null;
  }
  let renderedItem = null;
  const extraData = peek$(ctx, "extraData");
  const item = data[index];
  if (renderItem && !isNullOrUndefined(item)) {
    const itemProps = {
      data,
      extraData,
      index,
      item,
      type: getItemType ? (_a = getItemType(item, index)) != null ? _a : "" : ""
    };
    renderedItem = isFunction(renderItem) ? renderItem(itemProps) : React2__namespace.default.createElement(renderItem, itemProps);
  }
  return { index, item: data[index], renderedItem };
}
function useThrottleDebounce(mode) {
  const timeoutRef = React2.useRef(null);
  const lastCallTimeRef = React2.useRef(0);
  const lastArgsRef = React2.useRef(null);
  const clearTimeoutRef = () => {
    if (timeoutRef.current) {
      clearTimeout(timeoutRef.current);
      timeoutRef.current = null;
    }
  };
  const execute = React2.useCallback(
    (callback, delay, ...args) => {
      {
        const now = Date.now();
        lastArgsRef.current = args;
        if (now - lastCallTimeRef.current >= delay) {
          lastCallTimeRef.current = now;
          callback(...args);
          clearTimeoutRef();
        } else {
          clearTimeoutRef();
          timeoutRef.current = setTimeout(
            () => {
              if (lastArgsRef.current) {
                lastCallTimeRef.current = Date.now();
                callback(...lastArgsRef.current);
                timeoutRef.current = null;
                lastArgsRef.current = null;
              }
            },
            delay - (now - lastCallTimeRef.current)
          );
        }
      }
    },
    [mode]
  );
  return execute;
}

// src/utils/throttledOnScroll.ts
function useThrottledOnScroll(originalHandler, scrollEventThrottle) {
  const throttle = useThrottleDebounce("throttle");
  return (event) => throttle(originalHandler, scrollEventThrottle, { nativeEvent: event.nativeEvent });
}

// src/components/LegendList.tsx
var DEFAULT_DRAW_DISTANCE = 250;
var DEFAULT_ITEM_SIZE = 100;
var LegendList = typedMemo(
  typedForwardRef(function LegendList2(props, forwardedRef) {
    const { children, data: dataProp, renderItem: renderItemProp, ...restProps } = props;
    const isChildrenMode = children !== void 0 && dataProp === void 0;
    const processedProps = isChildrenMode ? {
      ...restProps,
      data: (isArray(children) ? children : React2__namespace.Children.toArray(children)).flat(1),
      renderItem: ({ item }) => item
    } : {
      ...restProps,
      data: dataProp || [],
      renderItem: renderItemProp
    };
    return /* @__PURE__ */ React2__namespace.createElement(StateProvider, null, /* @__PURE__ */ React2__namespace.createElement(LegendListInner, { ...processedProps, ref: forwardedRef }));
  })
);
var LegendListInner = typedForwardRef(function LegendListInner2(props, forwardedRef) {
  var _a;
  const {
    alignItemsAtEnd = false,
    columnWrapperStyle,
    contentContainerStyle: contentContainerStyleProp,
    data: dataProp = [],
    dataVersion,
    drawDistance = 250,
    enableAverages = true,
    estimatedItemSize: estimatedItemSizeProp,
    estimatedListSize,
    extraData,
    getEstimatedItemSize,
    getFixedItemSize,
    getItemType,
    horizontal,
    initialContainerPoolRatio = 2,
    initialScrollIndex: initialScrollIndexProp,
    initialScrollOffset: initialScrollOffsetProp,
    itemsAreEqual,
    keyExtractor: keyExtractorProp,
    ListEmptyComponent,
    ListHeaderComponent,
    maintainScrollAtEnd = false,
    maintainScrollAtEndThreshold = 0.1,
    maintainVisibleContentPosition = true,
    numColumns: numColumnsProp = 1,
    onEndReached,
    onEndReachedThreshold = 0.5,
    onItemSizeChanged,
    onLayout: onLayoutProp,
    onLoad,
    onMomentumScrollEnd,
    onRefresh,
    onScroll: onScrollProp,
    onStartReached,
    onStartReachedThreshold = 0.5,
    onStickyHeaderChange,
    onViewableItemsChanged,
    progressViewOffset,
    recycleItems = false,
    refreshControl,
    refreshing,
    refScrollView,
    renderItem,
    scrollEventThrottle,
    snapToIndices,
    stickyIndices,
    style: styleProp,
    suggestEstimatedItemSize,
    viewabilityConfig,
    viewabilityConfigCallbackPairs,
    waitForInitialLayout = true,
    ...rest
  } = props;
  const [renderNum, setRenderNum] = React2.useState(0);
  const initialScroll = initialScrollIndexProp || initialScrollOffsetProp ? typeof initialScrollIndexProp === "object" ? { index: initialScrollIndexProp.index || 0, viewOffset: initialScrollIndexProp.viewOffset || 0 } : { index: initialScrollIndexProp || 0, viewOffset: initialScrollOffsetProp || 0 } : void 0;
  const [canRender, setCanRender] = React2__namespace.useState(!IsNewArchitecture);
  const contentContainerStyle = { ...reactNative.StyleSheet.flatten(contentContainerStyleProp) };
  const style = { ...reactNative.StyleSheet.flatten(styleProp) };
  const stylePaddingTopState = extractPadding(style, contentContainerStyle, "Top");
  const stylePaddingBottomState = extractPadding(style, contentContainerStyle, "Bottom");
  const ctx = useStateContext();
  ctx.columnWrapperStyle = columnWrapperStyle || (contentContainerStyle ? createColumnWrapperStyle(contentContainerStyle) : void 0);
  const refScroller = React2.useRef(null);
  const combinedRef = useCombinedRef(refScroller, refScrollView);
  const estimatedItemSize = estimatedItemSizeProp != null ? estimatedItemSizeProp : DEFAULT_ITEM_SIZE;
  const scrollBuffer = (drawDistance != null ? drawDistance : DEFAULT_DRAW_DISTANCE) || 1;
  const keyExtractor = keyExtractorProp != null ? keyExtractorProp : (_item, index) => index.toString();
  const refState = React2.useRef();
  if (!refState.current) {
    if (!ctx.internalState) {
      const initialScrollLength = (estimatedListSize != null ? estimatedListSize : IsNewArchitecture ? { height: 0, width: 0 } : reactNative.Dimensions.get("window"))[horizontal ? "width" : "height"];
      ctx.internalState = {
        activeStickyIndex: void 0,
        averageSizes: {},
        columns: /* @__PURE__ */ new Map(),
        containerItemKeys: /* @__PURE__ */ new Set(),
        containerItemTypes: /* @__PURE__ */ new Map(),
        dataChangeNeedsScrollUpdate: false,
        enableScrollForNextCalculateItemsInView: true,
        endBuffered: -1,
        endNoBuffer: -1,
        endReachedBlockedByTimer: false,
        firstFullyOnScreenIndex: -1,
        idCache: [],
        idsInView: [],
        indexByKey: /* @__PURE__ */ new Map(),
        initialScroll,
        isAtEnd: false,
        isAtStart: false,
        isEndReached: false,
        isStartReached: false,
        lastBatchingAction: Date.now(),
        lastLayout: void 0,
        loadStartTime: Date.now(),
        minIndexSizeChanged: 0,
        nativeMarginTop: 0,
        positions: /* @__PURE__ */ new Map(),
        props: {},
        queuedCalculateItemsInView: 0,
        refScroller: void 0,
        scroll: 0,
        scrollAdjustHandler: new ScrollAdjustHandler(ctx),
        scrollForNextCalculateItemsInView: void 0,
        scrollHistory: [],
        scrollLength: initialScrollLength,
        scrollPending: 0,
        scrollPrev: 0,
        scrollPrevTime: 0,
        scrollProcessingEnabled: true,
        scrollTime: 0,
        sizes: /* @__PURE__ */ new Map(),
        sizesKnown: /* @__PURE__ */ new Map(),
        startBuffered: -1,
        startNoBuffer: -1,
        startReachedBlockedByTimer: false,
        stickyContainerPool: /* @__PURE__ */ new Set(),
        stickyContainers: /* @__PURE__ */ new Map(),
        timeoutSizeMessage: 0,
        timeouts: /* @__PURE__ */ new Set(),
        totalSize: 0,
        viewabilityConfigCallbackPairs: void 0
      };
      set$(ctx, "maintainVisibleContentPosition", maintainVisibleContentPosition);
      set$(ctx, "extraData", extraData);
    }
    refState.current = ctx.internalState;
  }
  const state = refState.current;
  const isFirst = !state.props.renderItem;
  const didDataChange = state.props.dataVersion !== dataVersion || state.props.data !== dataProp;
  if (didDataChange) {
    state.dataChangeNeedsScrollUpdate = true;
  }
  const throttleScrollFn = scrollEventThrottle && onScrollProp ? useThrottledOnScroll(onScrollProp, scrollEventThrottle) : onScrollProp;
  state.props = {
    alignItemsAtEnd,
    data: dataProp,
    dataVersion,
    enableAverages,
    estimatedItemSize,
    getEstimatedItemSize,
    getFixedItemSize,
    getItemType,
    horizontal: !!horizontal,
    initialContainerPoolRatio,
    initialScroll,
    itemsAreEqual,
    keyExtractor,
    maintainScrollAtEnd,
    maintainScrollAtEndThreshold,
    maintainVisibleContentPosition,
    numColumns: numColumnsProp,
    onEndReached,
    onEndReachedThreshold,
    onItemSizeChanged,
    onLoad,
    onScroll: throttleScrollFn,
    onStartReached,
    onStartReachedThreshold,
    onStickyHeaderChange,
    recycleItems: !!recycleItems,
    renderItem,
    scrollBuffer,
    snapToIndices,
    stickyIndicesArr: stickyIndices != null ? stickyIndices : [],
    stickyIndicesSet: React2.useMemo(() => new Set(stickyIndices != null ? stickyIndices : []), [stickyIndices == null ? void 0 : stickyIndices.join(",")]),
    stylePaddingBottom: stylePaddingBottomState,
    stylePaddingTop: stylePaddingTopState,
    suggestEstimatedItemSize: !!suggestEstimatedItemSize
  };
  state.refScroller = refScroller;
  const memoizedLastItemKeys = React2.useMemo(() => {
    if (!dataProp.length) return [];
    return Array.from(
      { length: Math.min(numColumnsProp, dataProp.length) },
      (_, i) => getId(state, dataProp.length - 1 - i)
    );
  }, [dataProp, dataVersion, numColumnsProp]);
  const initializeStateVars = () => {
    set$(ctx, "lastItemKeys", memoizedLastItemKeys);
    set$(ctx, "numColumns", numColumnsProp);
    const prevPaddingTop = peek$(ctx, "stylePaddingTop");
    setPaddingTop(ctx, state, { stylePaddingTop: stylePaddingTopState });
    refState.current.props.stylePaddingBottom = stylePaddingBottomState;
    let paddingDiff = stylePaddingTopState - prevPaddingTop;
    if (maintainVisibleContentPosition && paddingDiff && prevPaddingTop !== void 0 && reactNative.Platform.OS === "ios") {
      if (state.scroll < 0) {
        paddingDiff += state.scroll;
      }
      requestAdjust(ctx, state, paddingDiff);
    }
  };
  if (isFirst) {
    initializeStateVars();
    updateItemPositions(
      ctx,
      state,
      /*dataChanged*/
      true
    );
  }
  const initialContentOffset = React2.useMemo(() => {
    if (initialScroll) {
      const { index, viewOffset } = initialScroll;
      let initialContentOffset2 = viewOffset || 0;
      if (index !== void 0) {
        initialContentOffset2 += calculateOffsetForIndex(ctx, state, index);
      }
      refState.current.isStartReached = initialContentOffset2 < refState.current.scrollLength * onStartReachedThreshold;
      if (initialContentOffset2 > 0) {
        scrollTo(state, {
          animated: false,
          index,
          isInitialScroll: true,
          offset: initialContentOffset2,
          viewPosition: index === dataProp.length - 1 ? 1 : 0
        });
      }
      return initialContentOffset2;
    }
    return 0;
  }, [renderNum]);
  if (isFirst || didDataChange || numColumnsProp !== peek$(ctx, "numColumns")) {
    refState.current.lastBatchingAction = Date.now();
    if (!keyExtractorProp && !isFirst && didDataChange) {
      __DEV__ && warnDevOnce(
        "keyExtractor",
        "Changing data without a keyExtractor can cause slow performance and resetting scroll. If your list data can change you should use a keyExtractor with a unique id for best performance and behavior."
      );
      refState.current.sizes.clear();
      refState.current.positions.clear();
    }
  }
  const onLayoutHeader = React2.useCallback((rect, fromLayoutEffect) => {
    const size = rect[horizontal ? "width" : "height"];
    set$(ctx, "headerSize", size);
    if ((initialScroll == null ? void 0 : initialScroll.index) !== void 0) {
      if (IsNewArchitecture && reactNative.Platform.OS !== "android") {
        if (fromLayoutEffect) {
          setRenderNum((v) => v + 1);
        }
      } else {
        setTimeout(() => {
          scrollToIndex(ctx, state, { ...initialScroll, animated: false });
        }, 17);
      }
    }
  }, []);
  React2.useLayoutEffect(() => {
    if (snapToIndices) {
      updateSnapToOffsets(ctx, state);
    }
  }, [snapToIndices]);
  React2.useLayoutEffect(() => {
    const didAllocateContainers = dataProp.length > 0 && doInitialAllocateContainers(ctx, state);
    if (!didAllocateContainers) {
      checkResetContainers(
        ctx,
        state,
        /*isFirst*/
        isFirst,
        dataProp
      );
    }
  }, [dataProp, dataVersion, numColumnsProp]);
  React2.useLayoutEffect(() => {
    set$(ctx, "extraData", extraData);
  }, [extraData]);
  React2.useLayoutEffect(initializeStateVars, [
    dataVersion,
    memoizedLastItemKeys.join(","),
    numColumnsProp,
    stylePaddingBottomState,
    stylePaddingTopState
  ]);
  React2.useEffect(() => {
    const viewability = setupViewability({
      onViewableItemsChanged,
      viewabilityConfig,
      viewabilityConfigCallbackPairs
    });
    state.viewabilityConfigCallbackPairs = viewability;
    state.enableScrollForNextCalculateItemsInView = !viewability;
  }, [viewabilityConfig, viewabilityConfigCallbackPairs, onViewableItemsChanged]);
  if (!IsNewArchitecture) {
    useInit(() => {
      doInitialAllocateContainers(ctx, state);
    });
  }
  const onLayoutChange = React2.useCallback((layout) => {
    handleLayout(ctx, state, layout, setCanRender);
  }, []);
  const { onLayout } = useOnLayoutSync({
    onLayoutChange,
    onLayoutProp,
    ref: refScroller
    // the type of ScrollView doesn't include measure?
  });
  React2.useImperativeHandle(forwardedRef, () => {
    const scrollIndexIntoView = (options) => {
      const state2 = refState.current;
      if (state2) {
        const { index, ...rest2 } = options;
        const { startNoBuffer, endNoBuffer } = state2;
        if (index < startNoBuffer || index > endNoBuffer) {
          const viewPosition = index < startNoBuffer ? 0 : 1;
          scrollToIndex(ctx, state2, {
            ...rest2,
            index,
            viewPosition
          });
        }
      }
    };
    return {
      flashScrollIndicators: () => refScroller.current.flashScrollIndicators(),
      getNativeScrollRef: () => refScroller.current,
      getScrollableNode: () => refScroller.current.getScrollableNode(),
      getScrollResponder: () => refScroller.current.getScrollResponder(),
      getState: () => {
        const state2 = refState.current;
        return state2 ? {
          activeStickyIndex: state2.activeStickyIndex,
          contentLength: state2.totalSize,
          data: state2.props.data,
          end: state2.endNoBuffer,
          endBuffered: state2.endBuffered,
          isAtEnd: state2.isAtEnd,
          isAtStart: state2.isAtStart,
          positionAtIndex: (index) => state2.positions.get(getId(state2, index)),
          positions: state2.positions,
          scroll: state2.scroll,
          scrollLength: state2.scrollLength,
          sizeAtIndex: (index) => state2.sizesKnown.get(getId(state2, index)),
          sizes: state2.sizesKnown,
          start: state2.startNoBuffer,
          startBuffered: state2.startBuffered
        } : {};
      },
      scrollIndexIntoView,
      scrollItemIntoView: ({ item, ...props2 }) => {
        const data = refState.current.props.data;
        const index = data.indexOf(item);
        if (index !== -1) {
          scrollIndexIntoView({ index, ...props2 });
        }
      },
      scrollToEnd: (options) => {
        const data = refState.current.props.data;
        const stylePaddingBottom = refState.current.props.stylePaddingBottom;
        const index = data.length - 1;
        if (index !== -1) {
          const paddingBottom = stylePaddingBottom || 0;
          const footerSize = peek$(ctx, "footerSize") || 0;
          scrollToIndex(ctx, state, {
            index,
            viewOffset: -paddingBottom - footerSize + ((options == null ? void 0 : options.viewOffset) || 0),
            viewPosition: 1,
            ...options
          });
        }
      },
      scrollToIndex: (params) => scrollToIndex(ctx, state, params),
      scrollToItem: ({ item, ...props2 }) => {
        const data = refState.current.props.data;
        const index = data.indexOf(item);
        if (index !== -1) {
          scrollToIndex(ctx, state, { index, ...props2 });
        }
      },
      scrollToOffset: (params) => scrollTo(state, params),
      setScrollProcessingEnabled: (enabled) => {
        refState.current.scrollProcessingEnabled = enabled;
      },
      setVisibleContentAnchorOffset: (value) => {
        const val = typeof value === "function" ? value(peek$(ctx, "scrollAdjustUserOffset") || 0) : value;
        set$(ctx, "scrollAdjustUserOffset", val);
      }
    };
  }, []);
  if (reactNative.Platform.OS === "web") {
    React2.useEffect(() => {
      if (initialContentOffset) {
        scrollTo(state, { animated: false, offset: initialContentOffset });
      }
    }, []);
  }
  const fns = React2.useMemo(
    () => ({
      getRenderedItem: (key) => getRenderedItem(ctx, state, key),
      onScroll: (event) => onScroll(ctx, state, event),
      updateItemSize: (itemKey, sizeObj) => updateItemSize(ctx, state, itemKey, sizeObj)
    }),
    []
  );
  const onScrollHandler = React2.useMemo(() => {
    const onScrollFn = fns.onScroll;
    if (stickyIndices == null ? void 0 : stickyIndices.length) {
      const { animatedScrollY } = ctx;
      return reactNative.Animated.event([{ nativeEvent: { contentOffset: { [horizontal ? "x" : "y"]: animatedScrollY } } }], {
        listener: onScrollFn,
        useNativeDriver: true
      });
    }
    return onScrollFn;
  }, [stickyIndices == null ? void 0 : stickyIndices.length, horizontal, scrollEventThrottle]);
  return /* @__PURE__ */ React2__namespace.createElement(React2__namespace.Fragment, null, /* @__PURE__ */ React2__namespace.createElement(
    ListComponent,
    {
      ...rest,
      alignItemsAtEnd,
      canRender,
      contentContainerStyle,
      getRenderedItem: fns.getRenderedItem,
      horizontal,
      initialContentOffset,
      ListEmptyComponent: dataProp.length === 0 ? ListEmptyComponent : void 0,
      ListHeaderComponent,
      maintainVisibleContentPosition,
      onLayout,
      onLayoutHeader,
      onMomentumScrollEnd: (event) => {
        if (IsNewArchitecture) {
          requestAnimationFrame(() => {
            finishScrollTo(refState.current);
          });
        } else {
          setTimeout(() => {
            finishScrollTo(refState.current);
          }, 1e3);
        }
        if (onMomentumScrollEnd) {
          onMomentumScrollEnd(event);
        }
      },
      onScroll: onScrollHandler,
      recycleItems,
      refreshControl: refreshControl ? stylePaddingTopState > 0 ? React2__namespace.cloneElement(refreshControl, {
        progressViewOffset: (refreshControl.props.progressViewOffset || 0) + stylePaddingTopState
      }) : refreshControl : onRefresh && /* @__PURE__ */ React2__namespace.createElement(
        reactNative.RefreshControl,
        {
          onRefresh,
          progressViewOffset: (progressViewOffset || 0) + stylePaddingTopState,
          refreshing: !!refreshing
        }
      ),
      refScrollView: combinedRef,
      scrollAdjustHandler: (_a = refState.current) == null ? void 0 : _a.scrollAdjustHandler,
      scrollEventThrottle: reactNative.Platform.OS === "web" ? 16 : void 0,
      snapToIndices,
      stickyIndices,
      style,
      updateItemSize: fns.updateItemSize,
      waitForInitialLayout
    }
  ), __DEV__ && ENABLE_DEBUG_VIEW && /* @__PURE__ */ React2__namespace.createElement(DebugView, { state: refState.current }));
});

exports.LegendList = LegendList;
exports.useIsLastItem = useIsLastItem;
exports.useListScrollSize = useListScrollSize;
exports.useRecyclingEffect = useRecyclingEffect;
exports.useRecyclingState = useRecyclingState;
exports.useSyncLayout = useSyncLayout;
exports.useViewability = useViewability;
exports.useViewabilityAmount = useViewabilityAmount;
