"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.composeSourceMaps = void 0;
var _nodeFs = _interopRequireDefault(require("node:fs"));
var _nodePath = _interopRequireDefault(require("node:path"));
var _execa = _interopRequireDefault(require("execa"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/**
 * {@link composeSourceMaps} options.
 */

/**
 * Composes source maps generated by webpack-bundle and Hermes.
 *
 * Removes original source map files.
 */
const composeSourceMaps = async ({
  reactNativePath,
  packagerMapPath,
  compilerMapPath
}) => {
  const composedSourceMapPath = packagerMapPath + '.composed';
  try {
    await _execa.default.node(_nodePath.default.join(reactNativePath, 'scripts', 'compose-source-maps.js'), [packagerMapPath, compilerMapPath, '-o', composedSourceMapPath]);

    // Remove intermediate files
    await _nodeFs.default.promises.unlink(packagerMapPath);
    await _nodeFs.default.promises.unlink(compilerMapPath);
    await _nodeFs.default.promises.rename(composedSourceMapPath, packagerMapPath);
  } catch (error) {
    const message = error.toString();
    throw new Error(`[RepackHermesBytecodePlugin] Failed to compose source maps. Reason:\n${message})`);
  }
};
exports.composeSourceMaps = composeSourceMaps;