import fastifyPlugin from 'fastify-plugin';
import { Symbolicator } from './Symbolicator.js';
function getStackFromRequestBody(request) {
    let body;
    if (request.headers['content-type'] === 'application/json') {
        // RN >= 0.79 uses application/json
        body = request.body;
    }
    else {
        // RN < 0.79 uses text/plain
        body = JSON.parse(request.body);
    }
    return body.stack;
}
async function symbolicatePlugin(instance, { delegate, }) {
    const symbolicator = new Symbolicator(delegate.symbolicator);
    instance.post('/symbolicate', async (request, reply) => {
        try {
            const stack = getStackFromRequestBody(request);
            const platform = Symbolicator.inferPlatformFromStack(stack);
            if (!platform) {
                request.log.debug({ msg: 'Received stack', stack });
                reply.badRequest('Cannot infer platform from stack trace');
            }
            else {
                request.log.debug({ msg: 'Starting symbolication', platform, stack });
                const results = await symbolicator.process(request.log, stack);
                reply.send(results);
            }
        }
        catch (error) {
            request.log.error({
                msg: 'Failed to symbolicate',
                error: error.message,
            });
            reply.internalServerError();
        }
    });
}
export default fastifyPlugin(symbolicatePlugin, {
    name: 'symbolicate-plugin',
    dependencies: ['@fastify/sensible'],
});
