"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.reanimatedModuleRules = void 0;
const repack_1 = require("@callstack/repack");
exports.reanimatedModuleRules = {
    exclude: (0, repack_1.getModulePaths)([
        'react',
        'react-native',
        '@react-native',
        'react-native-macos',
        'react-native-windows',
        'react-native-tvos',
        '@callstack/react-native-visionos',
    ]),
    oneOf: [
        {
            test: /\.[cm]?ts$/,
            use: {
                loader: '@callstack/repack-plugin-reanimated/loader',
                options: {
                    babelPlugins: [
                        [
                            '@babel/plugin-syntax-typescript',
                            { isTSX: false, allowNamespaces: true },
                        ],
                    ],
                },
            },
        },
        {
            test: /\.[cm]?tsx$/,
            use: {
                loader: '@callstack/repack-plugin-reanimated/loader',
                options: {
                    babelPlugins: [
                        [
                            '@babel/plugin-syntax-typescript',
                            { isTSX: true, allowNamespaces: true },
                        ],
                    ],
                },
            },
        },
        {
            test: /\.[cm]?jsx?$/,
            use: {
                loader: '@callstack/repack-plugin-reanimated/loader',
                options: {
                    babelPlugins: ['babel-plugin-syntax-hermes-parser'],
                },
            },
        },
    ],
};
