"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReanimatedPlugin = void 0;
const rules_js_1 = require("./rules.js");
class ReanimatedPlugin {
    apply(compiler) {
        // add rules for transpiling wih reanimated loader
        compiler.options.module.rules.push(rules_js_1.reanimatedModuleRules);
        // ignore the 'setUpTests' warning from reanimated which is not relevant
        compiler.options.ignoreWarnings = compiler.options.ignoreWarnings ?? [];
        compiler.options.ignoreWarnings.push((warning) => /'`setUpTests` is available only in Jest environment\.'/.test(warning.message));
    }
}
exports.ReanimatedPlugin = ReanimatedPlugin;
