# Contributing

For bug reports and feature requests, please search in issues first (including the closed ones). If there are no duplicates, feel free to [submit an issue][issues] with an issue template.

**We'll probably ignore and close your issue if it's not using the existing templates or doesn't contain sufficient description.**

## Bug Report

When submitting a bug report, please make sure your issue contains **enough** information for reproducing the problem, including the options or the custom command being used, the link to the video, and other fields in the issue template.

## Feature Request

**Myne** is an ebook library client designed to give users easy access to the Gutenberg Project’s extensive collection of free assets. Our goal is to make exploring and enjoying literature straightforward and enjoyable. We focus on feature requests that fit our core mission and the essential principles of ebook accessibility and management.

Our library already includes a variety of features to enhance your reading experience, such as robust search capabilities, customizable reading settings, and efficient download options. While we're open to suggestions for improvements, we may not be able to accommodate requests that stray too far from our primary purpose or go beyond the scope of ebook management and accessibility. We kindly ask users to consider the library's intended functionality and limitations when submitting feature requests.

We appreciate the feedback and input from our users, and we are committed to continually improving **Myne** to meet the evolving needs of our user base. However, please understand that not all feature requests may be feasible or aligned with our app's mission and vision.

If you'd like to request a feature you deem necessary and useful, open a new Github issue with the Feature-Request template [here][feature-req].

## Pull Request

If you wish to contribute to the project by submitting code directly, please first leave a comment under the relevant issue or file a new issue, describe the changes you are about to make.

As per our project's guidelines, we adhere to [conventional commits][conv-commits]. Therefore, it's expected that all PRs align with this convention. Should a PR not meet these standards, we'll kindly request a review and revision.

Please use the provided Pull Request templates according to your needs. Currently, there are two to choose from:
- [General PR](.github/PULL_REQUEST_TEMPLATE/general_template.md): for all other PRs, including bug fixes, adding features etc.
- [Translation PR](.github/PULL_REQUEST_TEMPLATE/translations_template.md): specifically to be used for translation PRs

> [!TIP]
>
> To avoid multiple pull requests resolving the same issue, let others know you are working on it by saying so in a comment, or ask the issue to be assigned to yourself.

## Building From Source

Fork this project, import and compile it with the latest version of [Android Studio](https://developer.android.com/studio/). 

[issues]: https://github.com/Pool-Of-Tears/Myne/issues/new/choose
[feature-req]: https://github.com/Pool-Of-Tears/Myne/issues/new?assignees=&labels=enhancement&projects=&template=--feature-request.yml&title=%5BFeature+Request%5D
[conv-commits]:https://kapeli.com/cheat_sheets/Conventional_Commits.docset/Contents/Resources/Documents/index