/**
 * Copyright (c) [2022 - Present] Stɑrry Shivɑm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.starry.myne.helpers

object Constants {
    /** Name of database file. */
    const val DATABASE_NAME = "myne.db"

    /** Epub Mime Type. */
    const val EPUB_MIME_TYPE = "application/epub+zip"

    /** Placeholder for unknown error. */
    const val UNKNOWN_ERR = "unknown-error"

    // URLs
    const val DEV_EMAIL = "starry@krsh.dev"
    const val DEV_GITHUB_URL = "https://github.com/starry-shivam"
    const val DEV_TELEGRAM_URL = "https://t.me/starryboi"
    const val PROJECT_CONTRIBUTORS = "https://github.com/Pool-Of-Tears/Myne/graphs/contributors"
    const val GITHUB_REPO = "https://github.com/Pool-Of-Tears/Myne"
    const val WEBSITE = "https://pool-of-tears.github.io"
    const val PRIVACY_POLICY =
        "https://github.com/Pool-Of-Tears/Myne/blob/main/legal/PRIVACY-POLICY.md"
    const val GITHUB_ISSUE = "https://github.com/Pool-Of-Tears/Myne/issues/new/choose"
    const val TELEGRAM_GROUP = "https://t.me/PotApps"
    const val SUPPORT = "https://github.com/sponsors/starry-shivam"
}