# Contributing

For bug reports and feature requests, please search in issues first (including the closed ones). If
there are no duplicates, feel free to [submit an issue][issues] with an issue template.

**We'll probably ignore and close your issue if it's not using the existing templates or doesn't
contain sufficient description.**

## Bug Report

When submitting a bug report, please make sure your issue contains **enough** information for
reproducing the problem, including the options or the custom command being used, the link to the
video, and other fields in the issue template.

## Feature Request

**GreenStash** is designed to provide users with a straightforward and effective tool for managing
their finances on Android. Our focus is to offer essential budgeting functionalities in an intuitive
interface, helping users track their savings effortlessly. As such, we prioritize feature requests
that align with our core mission and the fundamental principles of budget management.

Our app already includes a range of features designed to assist users in budgeting effectively, such
as goal setting and customizable categories. While we are open to suggestions for improvements and
enhancements, we may not be able to accommodate requests for features that deviate significantly
from our app's primary purpose or that are beyond the scope of traditional budget management.
Therefore, we kindly ask our users to consider the app's intended functionality and limitations when
submitting feature requests.

We appreciate the feedback and input from our users, and we are committed to continually improving *
*GreenStash** to meet the evolving needs of our user base. However, please understand that not all
feature requests may be feasible or aligned with our app's mission and vision.

If you'd like to request a feature you deem necessary and useful, open a new Github issue with the
Feature-Request template [here][feature-req].

## Pull Request

If you wish to contribute to the project by submitting code directly, please first leave a comment
under the relevant issue or file a new issue, describe the changes you are about to make.

As per our project's guidelines, we adhere to [conventional commits][conv-commits]. Therefore, it's
expected that all PRs align with this convention. Should a PR not meet these standards, we'll kindly
request a review and revision.

Please use the provided Pull Request templates according to your needs. Currently, there are two to
choose from:

- [General PR](.github/PULL_REQUEST_TEMPLATE/general_template.md): for all other PRs, including bug
  fixes, adding features etc.
- [Translation PR](.github/PULL_REQUEST_TEMPLATE/translations_template.md): specifically to be used
  for translation PRs

> [!TIP]
>
> To avoid multiple pull requests resolving the same issue, let others know you are working on it by
> saying so in a comment, or ask the issue to be assigned to yourself.

## Building From Source

Fork this project, import and compile it with the latest version
of [Android Studio](https://developer.android.com/studio/).

[issues]: https://github.com/Pool-Of-Tears/GreenStash/issues/new/choose

[feature-req]: https://github.com/Pool-Of-Tears/GreenStash/issues/new?assignees=&labels=enhancement&projects=&template=--feature-request.yml&title=%5BFeature+Request%5D

[conv-commits]:https://kapeli.com/cheat_sheets/Conventional_Commits.docset/Contents/Resources/Documents/index