import { NoteContent } from './NoteContent';
import { DecryptedItemMutator } from '../../Abstract/Item/Mutator/DecryptedItemMutator';
import { SNNote } from './Note';
import { FeatureIdentifier, NoteType } from '@standardnotes/features';
export declare class NoteMutator extends DecryptedItemMutator<NoteContent> {
    set title(title: string);
    set text(text: string);
    set hidePreview(hidePreview: boolean);
    set preview_plain(preview_plain: string);
    set preview_html(preview_html: string | undefined);
    set spellcheck(spellcheck: boolean);
    set noteType(noteType: NoteType);
    set editorIdentifier(identifier: FeatureIdentifier | string | undefined);
    set authorizedForListed(authorizedForListed: boolean);
    toggleSpellcheck(): void;
    addNote(note: SNNote): void;
    removeNote(note: SNNote): void;
}
