"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.blockContentToNoteTextRendition = exports.stringIndexOfBlock = exports.bracketSyntaxForBlock = void 0;
function bracketSyntaxForBlock(block) {
    return {
        open: `<Block id=${block.id}>`,
        close: `</Block id=${block.id}>`,
    };
}
exports.bracketSyntaxForBlock = bracketSyntaxForBlock;
function stringIndexOfBlock(text, block) {
    const brackets = bracketSyntaxForBlock(block);
    const startIndex = text.indexOf(brackets.open);
    if (startIndex === -1) {
        return undefined;
    }
    const endIndex = text.indexOf(brackets.close) + brackets.close.length;
    return {
        begin: startIndex,
        end: endIndex,
    };
}
exports.stringIndexOfBlock = stringIndexOfBlock;
function blockContentToNoteTextRendition(block, content) {
    const brackets = bracketSyntaxForBlock(block);
    return `${brackets.open}${content}${brackets.close}`;
}
exports.blockContentToNoteTextRendition = blockContentToNoteTextRendition;
