import { Uuid } from '@standardnotes/common';
import { ComponentPermission, FeatureDescription } from '@standardnotes/features';
import { ComponentContent } from './ComponentContent';
import { DecryptedItemMutator } from '../../Abstract/Item/Mutator/DecryptedItemMutator';
export declare class ComponentMutator extends DecryptedItemMutator<ComponentContent> {
    set active(active: boolean);
    set isMobileDefault(isMobileDefault: boolean);
    set defaultEditor(defaultEditor: boolean);
    set componentData(componentData: Record<string, unknown>);
    set package_info(package_info: FeatureDescription);
    set local_url(local_url: string);
    set hosted_url(hosted_url: string);
    set valid_until(valid_until: Date);
    set permissions(permissions: ComponentPermission[]);
    set name(name: string);
    set offlineOnly(offlineOnly: boolean);
    associateWithItem(uuid: Uuid): void;
    disassociateWithItem(uuid: Uuid): void;
    removeAssociatedItemId(uuid: Uuid): void;
    removeDisassociatedItemId(uuid: Uuid): void;
    setLastSize(size: string): void;
}
