import { DecryptedItemInterface } from './../../Abstract/Item/Interfaces/DecryptedItem';
import { DecryptedPayloadInterface } from './../../Abstract/Payload/Interfaces/DecryptedPayload';
import { NoteContent } from '../../Syncable/Note';
import { HistoryEntryInterface } from './HistoryEntryInterface';
export declare class HistoryEntry implements HistoryEntryInterface {
    readonly payload: DecryptedPayloadInterface<NoteContent>;
    readonly previousEntry?: HistoryEntry;
    protected readonly defaultContentKeyToDiffOn: keyof NoteContent;
    protected readonly textCharDiffLength: number;
    protected readonly hasPreviousEntry: boolean;
    constructor(payload: DecryptedPayloadInterface<NoteContent>, previousEntry?: HistoryEntry);
    itemFromPayload(): DecryptedItemInterface;
    isSameAsEntry(entry: HistoryEntry): boolean;
    isDiscardable(): boolean;
    operationVector(): number;
    deltaSize(): number;
}
