import { SearchableDecryptedItem } from './Types';
import { ItemContent } from '../../../Abstract/Content/ItemContent';
import { DecryptedItem } from '../../../Abstract/Item';
import { DecryptedPayloadInterface } from '../../../Abstract/Payload/Interfaces/DecryptedPayload';
import { SNTag } from '../../../Syncable/Tag';
interface ItemWithTagsContent extends ItemContent {
    tags: SNTag[];
}
export declare class ItemWithTags extends DecryptedItem implements SearchableDecryptedItem {
    private item;
    readonly tags?: SNTag[] | undefined;
    constructor(payload: DecryptedPayloadInterface<ItemWithTagsContent>, item: SearchableDecryptedItem, tags?: SNTag[] | undefined);
    static Create(payload: DecryptedPayloadInterface<ItemContent>, item: SearchableDecryptedItem, tags?: SNTag[]): ItemWithTags;
    get tagsCount(): number;
    get title(): string | undefined;
    get text(): string | undefined;
}
export {};
