import { ContentType } from '@standardnotes/common';
import { ItemDelta } from '../Index/ItemDelta';
import { DisplayControllerOptions } from './DisplayOptions';
import { DisplayItem, ReadonlyItemCollection } from './Types';
export declare class ItemDisplayController<I extends DisplayItem> {
    private readonly collection;
    readonly contentTypes: ContentType[];
    private options;
    private sortMap;
    private sortedItems;
    private needsSort;
    constructor(collection: ReadonlyItemCollection, contentTypes: ContentType[], options: DisplayControllerOptions);
    items(): I[];
    setDisplayOptions(displayOptions: Partial<DisplayControllerOptions>): void;
    onCollectionChange(delta: ItemDelta): void;
    private filterThenSortElements;
    /** Resort the sortedItems array, and update the saved positions */
    private resortItems;
}
