"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeltaRemoteDataConflicts = void 0;
const Conflict_1 = require("./Conflict");
const Payload_1 = require("../../Abstract/Payload");
const DeltaEmit_1 = require("./Abstract/DeltaEmit");
const ApplyDirtyState_1 = require("./Utilities/ApplyDirtyState");
class DeltaRemoteDataConflicts {
    constructor(baseCollection, applyCollection, historyMap) {
        this.baseCollection = baseCollection;
        this.applyCollection = applyCollection;
        this.historyMap = historyMap;
    }
    result() {
        const result = {
            emits: [],
            ignored: [],
            source: Payload_1.PayloadEmitSource.RemoteRetrieved,
        };
        for (const apply of this.applyCollection.all()) {
            const base = this.baseCollection.find(apply.uuid);
            const isBaseDeleted = base == undefined;
            if (isBaseDeleted) {
                result.emits.push((0, ApplyDirtyState_1.payloadByFinalizingSyncState)(apply, this.baseCollection));
                continue;
            }
            const delta = new Conflict_1.ConflictDelta(this.baseCollection, base, apply, this.historyMap);
            (0, DeltaEmit_1.extendSyncDelta)(result, delta.result());
        }
        return result;
    }
}
exports.DeltaRemoteDataConflicts = DeltaRemoteDataConflicts;
