import { UuidMap } from '@standardnotes/utils';
import { ContentType, Uuid } from '@standardnotes/common';
import { ItemContent } from '../../Abstract/Content/ItemContent';
import { ContentReference } from '../../Abstract/Item';
export interface CollectionElement {
    uuid: Uuid;
    content_type: ContentType;
    dirty?: boolean;
    deleted?: boolean;
}
export interface DecryptedCollectionElement<C extends ItemContent = ItemContent> extends CollectionElement {
    content: C;
    references: ContentReference[];
}
export interface DeletedCollectionElement extends CollectionElement {
    content: undefined;
    deleted: true;
}
export interface EncryptedCollectionElement extends CollectionElement {
    content: string;
    errorDecrypting: boolean;
}
export declare abstract class Collection<Element extends Decrypted | Encrypted | Deleted, Decrypted extends DecryptedCollectionElement, Encrypted extends EncryptedCollectionElement, Deleted extends DeletedCollectionElement> {
    readonly map: Partial<Record<Uuid, Element>>;
    readonly typedMap: Partial<Record<ContentType, Element[]>>;
    /** An array of uuids of items that are dirty */
    dirtyIndex: Set<Uuid>;
    /** An array of uuids of items that are not marked as deleted */
    nondeletedIndex: Set<Uuid>;
    /** An array of uuids of items that are errorDecrypting or waitingForKey */
    invalidsIndex: Set<Uuid>;
    readonly referenceMap: UuidMap;
    /** Maintains an index for each item uuid where the value is an array of uuids that are
     * conflicts of that item. So if Note B and C are conflicts of Note A,
     * conflictMap[A.uuid] == [B.uuid, C.uuid] */
    readonly conflictMap: UuidMap;
    isDecryptedElement: (e: Decrypted | Encrypted | Deleted) => e is Decrypted;
    isEncryptedElement: (e: Decrypted | Encrypted | Deleted) => e is Encrypted;
    isErrorDecryptingElement: (e: Decrypted | Encrypted | Deleted) => e is Encrypted;
    isDeletedElement: (e: Decrypted | Encrypted | Deleted) => e is Deleted;
    isNonDeletedElement: (e: Decrypted | Encrypted | Deleted) => e is Decrypted | Encrypted;
    constructor(copy?: boolean, mapCopy?: Partial<Record<Uuid, Element>>, typedMapCopy?: Partial<Record<ContentType, Element[]>>, referenceMapCopy?: UuidMap, conflictMapCopy?: UuidMap);
    uuids(): Uuid[];
    all(contentType?: ContentType | ContentType[]): Element[];
    /** Returns all elements that are not marked as deleted */
    nondeletedElements(): Element[];
    /** Returns all elements that are errorDecrypting or waitingForKey */
    invalidElements(): Encrypted[];
    /** Returns all elements that are marked as dirty */
    dirtyElements(): Element[];
    findAll(uuids: Uuid[]): Element[];
    find(uuid: Uuid): Element | undefined;
    has(uuid: Uuid): boolean;
    /**
     * If an item is not found, an `undefined` element
     * will be inserted into the array.
     */
    findAllIncludingBlanks<E extends Element>(uuids: Uuid[]): (E | Deleted | undefined)[];
    set(elements: Element | Element[]): void;
    discard(elements: Element | Element[]): void;
    uuidReferencesForUuid(uuid: Uuid): Uuid[];
    uuidsThatReferenceUuid(uuid: Uuid): Uuid[];
    referencesForElement(element: Decrypted): Element[];
    conflictsOf(uuid: Uuid): Element[];
    elementsReferencingElement(element: Decrypted, contentType?: ContentType): Element[];
    private setToTypedMap;
    private deleteFromTypedMap;
}
