import { DecryptedTransferPayload } from './DecryptedTransferPayload';
import { DeletedTransferPayload } from './DeletedTransferPayload';
import { EncryptedTransferPayload } from './EncryptedTransferPayload';
import { TransferPayload } from './TransferPayload';
export declare type FullyFormedTransferPayload = DecryptedTransferPayload | EncryptedTransferPayload | DeletedTransferPayload;
export declare function isDecryptedTransferPayload(payload: TransferPayload): payload is DecryptedTransferPayload;
export declare function isEncryptedTransferPayload(payload: TransferPayload): payload is EncryptedTransferPayload;
export declare function isErrorDecryptingTransferPayload(payload: TransferPayload): payload is EncryptedTransferPayload;
export declare function isDeletedTransferPayload(payload: TransferPayload): payload is DeletedTransferPayload;
export declare function isCorruptTransferPayload(payload: TransferPayload): boolean;
