export declare enum PayloadEmitSource {
    /** When an observer registers to stream items, the items are pushed immediately to the observer */
    InitialObserverRegistrationPush = 1,
    /**
     * Payload when a client modifies item property then maps it to update UI.
     * This also indicates that the item was dirtied
     */
    LocalChanged = 2,
    LocalInserted = 3,
    LocalDatabaseLoaded = 4,
    /** The payload returned by offline sync operation */
    OfflineSyncSaved = 5,
    LocalRetrieved = 6,
    FileImport = 7,
    ComponentRetrieved = 8,
    /** Payloads received from an external component with the intention of creating a new item */
    ComponentCreated = 9,
    /**
     * When the payloads are about to sync, they are emitted by the sync service with updated
     * values of lastSyncBegan. Payloads emitted from this source indicate that these payloads
     * have been saved to disk, and are about to be synced
     */
    PreSyncSave = 10,
    RemoteRetrieved = 11,
    RemoteSaved = 12
}
/**
 * Whether the changed payload represents only an internal change that shouldn't
 * require a UI refresh
 */
export declare function isPayloadSourceInternalChange(source: PayloadEmitSource): boolean;
export declare function isPayloadSourceRetrieved(source: PayloadEmitSource): boolean;
