import { Uuid } from '@standardnotes/common';
import { SyncResolvedParams, SyncResolvedPayload } from '../../../Runtime/Deltas/Utilities/SyncResolvedPayload';
import { ItemContent } from '../../Content/ItemContent';
import { ContentReference } from '../../Reference/ContentReference';
import { DecryptedTransferPayload } from '../../TransferPayload/Interfaces/DecryptedTransferPayload';
import { DecryptedPayloadInterface } from '../Interfaces/DecryptedPayload';
import { PayloadSource } from '../Types/PayloadSource';
import { PurePayload } from './PurePayload';
export declare class DecryptedPayload<C extends ItemContent = ItemContent, T extends DecryptedTransferPayload<C> = DecryptedTransferPayload<C>> extends PurePayload<T> implements DecryptedPayloadInterface<C> {
    readonly content: C;
    readonly deleted: false;
    constructor(rawPayload: T, source?: PayloadSource);
    get references(): ContentReference[];
    getReference(uuid: Uuid): ContentReference;
    ejected(): DecryptedTransferPayload<C>;
    copy(override?: Partial<T>, source?: PayloadSource): this;
    copyAsSyncResolved(override?: Partial<T> & SyncResolvedParams, source?: PayloadSource): SyncResolvedPayload;
}
