import { ContentType, Uuid } from '@standardnotes/common';
import { TransferPayload } from './../../TransferPayload/Interfaces/TransferPayload';
import { ItemInterface } from '../Interfaces/ItemInterface';
import { ConflictStrategy } from '../Types/ConflictStrategy';
import { PredicateInterface } from '../../../Runtime/Predicate/Interface';
import { SingletonStrategy } from '../Types/SingletonStrategy';
import { PayloadInterface } from '../../Payload/Interfaces/PayloadInterface';
import { HistoryEntryInterface } from '../../../Runtime/History/HistoryEntryInterface';
export declare abstract class GenericItem<P extends PayloadInterface = PayloadInterface> implements ItemInterface<P> {
    payload: P;
    readonly duplicateOf?: Uuid;
    readonly createdAtString?: string;
    updatedAtString?: string;
    userModifiedDate: Date;
    constructor(payload: P);
    get uuid(): string;
    get content_type(): ContentType;
    get created_at(): Date;
    /**
     * The date timestamp the server set for this item upon it being synced
     * Undefined if never synced to a remote server.
     */
    get serverUpdatedAt(): Date;
    get serverUpdatedAtTimestamp(): number | undefined;
    /** @deprecated Use serverUpdatedAt instead */
    get updated_at(): Date | undefined;
    get dirty(): boolean | undefined;
    get lastSyncBegan(): Date | undefined;
    get lastSyncEnd(): Date | undefined;
    get duplicate_of(): string | undefined;
    payloadRepresentation(override?: Partial<TransferPayload>): P;
    /** Whether the item has never been synced to a server */
    get neverSynced(): boolean;
    /**
     * Subclasses can override this getter to return true if they want only
     * one of this item to exist, depending on custom criteria.
     */
    get isSingleton(): boolean;
    /** The predicate by which singleton items should be unique */
    singletonPredicate<T extends ItemInterface>(): PredicateInterface<T>;
    get singletonStrategy(): SingletonStrategy;
    /**
     * Subclasses can override this method and provide their own opinion on whether
     * they want to be duplicated. For example, if this.content.x = 12 and
     * item.content.x = 13, this function can be overriden to always return
     * ConflictStrategy.KeepBase to say 'don't create a duplicate at all, the
     * change is not important.'
     *
     * In the default implementation, we create a duplicate if content differs.
     * However, if they only differ by references, we KEEP_LEFT_MERGE_REFS.
     *
     * Left returns to our current item, and Right refers to the incoming item.
     */
    strategyWhenConflictingWithItem(item: ItemInterface, previousRevision?: HistoryEntryInterface): ConflictStrategy;
    satisfiesPredicate(predicate: PredicateInterface<ItemInterface>): boolean;
}
