import { EncryptedTransferPayload } from './../../TransferPayload/Interfaces/EncryptedTransferPayload';
import { EncryptedItemInterface } from '../Interfaces/EncryptedItem';
import { EncryptedPayloadInterface } from '../../Payload/Interfaces/EncryptedPayload';
import { GenericItem } from './GenericItem';
export declare class EncryptedItem extends GenericItem<EncryptedPayloadInterface> implements EncryptedItemInterface {
    constructor(payload: EncryptedPayloadInterface);
    get version(): import("@standardnotes/common").ProtocolVersion;
    payloadRepresentation(override?: Partial<EncryptedTransferPayload>): EncryptedPayloadInterface;
    get errorDecrypting(): boolean;
    get waitingForKey(): boolean;
    get content(): string;
    get auth_hash(): string | undefined;
}
