import { Uuid } from '@standardnotes/common';
import { DecryptedTransferPayload } from './../../TransferPayload/Interfaces/DecryptedTransferPayload';
import { AppDataField } from '../Types/AppDataField';
import { ComponentDataDomain, DefaultAppDomain } from '../Types/DefaultAppDomain';
import { DecryptedItemInterface } from '../Interfaces/DecryptedItem';
import { DecryptedPayloadInterface } from '../../Payload/Interfaces/DecryptedPayload';
import { GenericItem } from './GenericItem';
import { ItemContent } from '../../Content/ItemContent';
import { PrefKey } from '../../../Syncable/UserPrefs/PrefKey';
import { ContentReference } from '../../Reference/ContentReference';
export declare class DecryptedItem<C extends ItemContent = ItemContent> extends GenericItem<DecryptedPayloadInterface<C>> implements DecryptedItemInterface<C> {
    readonly conflictOf?: Uuid;
    readonly protected: boolean;
    readonly trashed: boolean;
    readonly pinned: boolean;
    readonly archived: boolean;
    readonly locked: boolean;
    readonly starred: boolean;
    constructor(payload: DecryptedPayloadInterface<C>);
    static DefaultAppDomain(): string;
    get content(): C;
    get references(): ContentReference[];
    isReferencingItem(item: DecryptedItemInterface): boolean;
    /**
     * Inside of content is a record called `appData` (which should have been called `domainData`).
     * It was named `appData` as a way to indicate that it can house data for multiple apps.
     * Each key of appData is a domain string, which was originally designed
     * to allow for multiple 3rd party apps who share access to the same data to store data
     * in an isolated location. This design premise is antiquited and no longer pursued,
     * however we continue to use it as not to uncesesarily create a large data migration
     * that would require users to sync all their data.
     *
     * domainData[DomainKey] will give you another Record<string, any>.
     *
     * Currently appData['org.standardnotes.sn'] returns an object of type AppData.
     * And appData['org.standardnotes.sn.components] returns an object of type ComponentData
     */
    getDomainData(domain: typeof ComponentDataDomain | typeof DefaultAppDomain): undefined | Record<string, unknown>;
    getAppDomainValue<T>(key: AppDataField | PrefKey): T | undefined;
    getAppDomainValueWithDefault<T, D extends T>(key: AppDataField | PrefKey, defaultValue: D): T;
    payloadRepresentation(override?: Partial<DecryptedTransferPayload<C>>): DecryptedPayloadInterface<C>;
    /**
     * During sync conflicts, when determing whether to create a duplicate for an item,
     * we can omit keys that have no meaningful weight and can be ignored. For example,
     * if one component has active = true and another component has active = false,
     * it would be needless to duplicate them, so instead we ignore that value.
     */
    contentKeysToIgnoreWhenCheckingEquality<C extends ItemContent = ItemContent>(): (keyof C)[];
    /** Same as `contentKeysToIgnoreWhenCheckingEquality`, but keys inside appData[Item.AppDomain] */
    appDataContentKeysToIgnoreWhenCheckingEquality(): AppDataField[];
    getContentCopy(): any;
    isItemContentEqualWith(otherItem: DecryptedItemInterface): boolean;
}
