import { Uuid } from '@standardnotes/common';
import { ContextPayload } from './ContextPayload';
import { ItemContent } from '../Content/ItemContent';
import { DecryptedPayloadInterface, DeletedPayloadInterface, EncryptedPayloadInterface } from '../Payload';
export declare function isEncryptedLocalStoragePayload(p: LocalStorageEncryptedContextualPayload | LocalStorageDecryptedContextualPayload): p is LocalStorageEncryptedContextualPayload;
export interface LocalStorageEncryptedContextualPayload extends ContextPayload {
    auth_hash?: string;
    auth_params?: unknown;
    content: string;
    deleted: false;
    created_at_timestamp: number;
    created_at: Date;
    dirty: boolean;
    duplicate_of: Uuid | undefined;
    enc_item_key: string;
    errorDecrypting: boolean;
    items_key_id: string | undefined;
    updated_at_timestamp: number;
    updated_at: Date;
    waitingForKey: boolean;
}
export interface LocalStorageDecryptedContextualPayload<C extends ItemContent = ItemContent> extends ContextPayload {
    content: C;
    created_at_timestamp: number;
    created_at: Date;
    deleted: false;
    dirty: boolean;
    duplicate_of?: Uuid;
    updated_at_timestamp: number;
    updated_at: Date;
}
export interface LocalStorageDeletedContextualPayload extends ContextPayload {
    content: undefined;
    created_at_timestamp: number;
    created_at: Date;
    deleted: true;
    dirty: true;
    duplicate_of?: Uuid;
    updated_at_timestamp: number;
    updated_at: Date;
}
export declare function CreateEncryptedLocalStorageContextPayload(fromPayload: EncryptedPayloadInterface): LocalStorageEncryptedContextualPayload;
export declare function CreateDecryptedLocalStorageContextPayload(fromPayload: DecryptedPayloadInterface): LocalStorageDecryptedContextualPayload;
export declare function CreateDeletedLocalStorageContextPayload(fromPayload: DeletedPayloadInterface): LocalStorageDeletedContextualPayload;
