import { Uuid } from '@standardnotes/common';
import { AppData } from '../Item/Types/DefaultAppDomain';
import { ContentReference } from '../Reference/ContentReference';
export interface SpecializedContent {
}
export interface ItemContent {
    references: ContentReference[];
    conflict_of?: Uuid;
    protected?: boolean;
    trashed?: boolean;
    pinned?: boolean;
    archived?: boolean;
    starred?: boolean;
    locked?: boolean;
    appData?: AppData;
}
/**
 * Modifies the input object to fill in any missing required values from the
 * content body.
 */
export declare function FillItemContent<C extends ItemContent = ItemContent>(content: Partial<C>): C;
export declare function FillItemContentSpecialized<S extends SpecializedContent, C extends ItemContent = ItemContent>(content: S): C;
