"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionPlanName = void 0;
const ValueObject_1 = require("../Core/ValueObject");
const Result_1 = require("../Core/Result");
class SubscriptionPlanName extends ValueObject_1.ValueObject {
    static NAMES = {
        PlusPlan: 'PLUS_PLAN',
        ProPlan: 'PRO_PLAN',
    };
    get value() {
        return this.props.value;
    }
    constructor(props) {
        super(props);
    }
    static create(name) {
        const isValidName = Object.values(this.NAMES).includes(name);
        if (!isValidName) {
            return Result_1.Result.fail(`Invalid subscription plan name: ${name}`);
        }
        else {
            return Result_1.Result.ok(new SubscriptionPlanName({ value: name }));
        }
    }
}
exports.SubscriptionPlanName = SubscriptionPlanName;
