"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedVaultUserPermission = void 0;
const Result_1 = require("../Core/Result");
const ValueObject_1 = require("../Core/ValueObject");
class SharedVaultUserPermission extends ValueObject_1.ValueObject {
    static PERMISSIONS = {
        Read: 'read',
        Write: 'write',
        Admin: 'admin',
    };
    get value() {
        return this.props.value;
    }
    constructor(props) {
        super(props);
    }
    static create(sharedVaultUserPermission) {
        const isValidPermission = Object.values(this.PERMISSIONS).includes(sharedVaultUserPermission);
        if (!isValidPermission) {
            return Result_1.Result.fail(`Invalid shared vault user permission ${sharedVaultUserPermission}`);
        }
        else {
            return Result_1.Result.ok(new SharedVaultUserPermission({ value: sharedVaultUserPermission }));
        }
    }
}
exports.SharedVaultUserPermission = SharedVaultUserPermission;
