"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingName = void 0;
const Result_1 = require("../Core/Result");
const ValueObject_1 = require("../Core/ValueObject");
class SettingName extends ValueObject_1.ValueObject {
    static NAMES = {
        MfaSecret: 'MFA_SECRET',
        ExtensionKey: 'EXTENSION_KEY',
        EmailBackupFrequency: 'EMAIL_BACKUP_FREQUENCY',
        DropboxBackupFrequency: 'DROPBOX_BACKUP_FREQUENCY',
        DropboxBackupToken: 'DROPBOX_BACKUP_TOKEN',
        OneDriveBackupFrequency: 'ONE_DRIVE_BACKUP_FREQUENCY',
        OneDriveBackupToken: 'ONE_DRIVE_BACKUP_TOKEN',
        GoogleDriveBackupFrequency: 'GOOGLE_DRIVE_BACKUP_FREQUENCY',
        GoogleDriveBackupToken: 'GOOGLE_DRIVE_BACKUP_TOKEN',
        MuteFailedBackupsEmails: 'MUTE_FAILED_BACKUPS_EMAILS',
        MuteFailedCloudBackupsEmails: 'MUTE_FAILED_CLOUD_BACKUPS_EMAILS',
        MuteSignInEmails: 'MUTE_SIGN_IN_EMAILS',
        MuteMarketingEmails: 'MUTE_MARKETING_EMAILS',
        ListedAuthorSecrets: 'LISTED_AUTHOR_SECRETS',
        LogSessionUserAgent: 'LOG_SESSION_USER_AGENT',
        RecoveryCodes: 'RECOVERY_CODES',
        FileUploadBytesLimit: 'FILE_UPLOAD_BYTES_LIMIT',
        FileUploadBytesUsed: 'FILE_UPLOAD_BYTES_USED',
    };
    get value() {
        return this.props.value;
    }
    isSensitive() {
        return [SettingName.NAMES.MfaSecret, SettingName.NAMES.ExtensionKey].includes(this.props.value);
    }
    isASubscriptionSetting() {
        return [
            SettingName.NAMES.FileUploadBytesLimit,
            SettingName.NAMES.FileUploadBytesUsed,
            SettingName.NAMES.MuteSignInEmails,
        ].includes(this.props.value);
    }
    isARegularOnlySubscriptionSetting() {
        return [SettingName.NAMES.FileUploadBytesLimit, SettingName.NAMES.FileUploadBytesUsed].includes(this.props.value);
    }
    isASharedAndRegularOnlySubscriptionSetting() {
        return [SettingName.NAMES.MuteSignInEmails].includes(this.props.value);
    }
    constructor(props) {
        super(props);
    }
    static create(name) {
        const isValidName = Object.values(this.NAMES).includes(name);
        if (!isValidName) {
            return Result_1.Result.fail(`Invalid setting name: ${name}`);
        }
        else {
            return Result_1.Result.ok(new SettingName({ value: name }));
        }
    }
}
exports.SettingName = SettingName;
