import { Result } from '../Core/Result';
import { ValueObject } from '../Core/ValueObject';
import { SettingNameProps } from './SettingNameProps';
export declare class SettingName extends ValueObject<SettingNameProps> {
    static readonly NAMES: {
        MfaSecret: string;
        ExtensionKey: string;
        EmailBackupFrequency: string;
        DropboxBackupFrequency: string;
        DropboxBackupToken: string;
        OneDriveBackupFrequency: string;
        OneDriveBackupToken: string;
        GoogleDriveBackupFrequency: string;
        GoogleDriveBackupToken: string;
        MuteFailedBackupsEmails: string;
        MuteFailedCloudBackupsEmails: string;
        MuteSignInEmails: string;
        MuteMarketingEmails: string;
        ListedAuthorSecrets: string;
        LogSessionUserAgent: string;
        RecoveryCodes: string;
        FileUploadBytesLimit: string;
        FileUploadBytesUsed: string;
    };
    get value(): string;
    isSensitive(): boolean;
    isASubscriptionSetting(): boolean;
    isARegularOnlySubscriptionSetting(): boolean;
    isASharedAndRegularOnlySubscriptionSetting(): boolean;
    private constructor();
    static create(name: string): Result<SettingName>;
}
//# sourceMappingURL=SettingName.d.ts.map