"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceIdentifier = void 0;
const ValueObject_1 = require("../Core/ValueObject");
const Result_1 = require("../Core/Result");
class ServiceIdentifier extends ValueObject_1.ValueObject {
    static NAMES = {
        AnalyticsWorker: 'AnalyticsWorker',
        AnalyticsScheduledTask: 'AnalyticsScheduledTask',
        ApiGateway: 'ApiGateway',
        Auth: 'Auth',
        AuthWorker: 'AuthWorker',
        AuthScheduledTask: 'AuthScheduledTask',
        SyncingServer: 'SyncingServer',
        SyncingServerWorker: 'SyncingServerWorker',
        Revisions: 'Revisions',
        RevisionsWorker: 'RevisionsWorker',
        Files: 'Files',
        FilesWorker: 'FilesWorker',
        SchedulerWorker: 'SchedulerWorker',
        SchedulerScheduledTask: 'SchedulerScheduledTask',
        Email: 'Email',
        EmailWorker: 'EmailWorker',
        EmailBounceProcessor: 'EmailBounceProcessor',
        EmailScheduledTask: 'EmailScheduledTask',
        Websockets: 'Websockets',
        WebsocketsWorker: 'WebsocketsWorker',
    };
    get value() {
        return this.props.value;
    }
    constructor(props) {
        super(props);
    }
    static create(name) {
        const isValidName = Object.values(this.NAMES).includes(name);
        if (!isValidName) {
            return Result_1.Result.fail(`Invalid subscription plan name: ${name}`);
        }
        else {
            return Result_1.Result.ok(new ServiceIdentifier({ value: name }));
        }
    }
}
exports.ServiceIdentifier = ServiceIdentifier;
