import { ValueObject } from '../Core/ValueObject';
import { Result } from '../Core/Result';
import { ServiceIdentifierProps } from './ServiceIdentifierProps';
export declare class ServiceIdentifier extends ValueObject<ServiceIdentifierProps> {
    static readonly NAMES: {
        AnalyticsWorker: string;
        AnalyticsScheduledTask: string;
        ApiGateway: string;
        Auth: string;
        AuthWorker: string;
        AuthScheduledTask: string;
        SyncingServer: string;
        SyncingServerWorker: string;
        Revisions: string;
        RevisionsWorker: string;
        Files: string;
        FilesWorker: string;
        SchedulerWorker: string;
        SchedulerScheduledTask: string;
        Email: string;
        EmailWorker: string;
        EmailBounceProcessor: string;
        EmailScheduledTask: string;
        Websockets: string;
        WebsocketsWorker: string;
    };
    get value(): string;
    private constructor();
    static create(name: string): Result<ServiceIdentifier>;
}
//# sourceMappingURL=ServiceIdentifier.d.ts.map