"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationType = void 0;
const Result_1 = require("../Core/Result");
const ValueObject_1 = require("../Core/ValueObject");
class NotificationType extends ValueObject_1.ValueObject {
    static TYPES = {
        SharedVaultItemRemoved: 'shared_vault_item_removed',
        SelfRemovedFromSharedVault: 'self_removed_from_shared_vault',
        UserRemovedFromSharedVault: 'user_removed_from_shared_vault',
        UserDesignatedAsSurvivor: 'user_designated_as_survivor',
        UserAddedToSharedVault: 'user_added_to_shared_vault',
        SharedVaultInviteCanceled: 'shared_vault_invite_canceled',
        SharedVaultFileUploaded: 'shared_vault_file_uploaded',
        SharedVaultFileRemoved: 'shared_vault_file_removed',
    };
    get value() {
        return this.props.value;
    }
    constructor(props) {
        super(props);
    }
    static create(notificationType) {
        const isValidType = Object.values(this.TYPES).includes(notificationType);
        if (!isValidType) {
            return Result_1.Result.fail(`Invalid notification type: ${notificationType}`);
        }
        else {
            return Result_1.Result.ok(new NotificationType({ value: notificationType }));
        }
    }
}
exports.NotificationType = NotificationType;
