import { Result } from '../Core/Result';
import { ValueObject } from '../Core/ValueObject';
import { NotificationTypeProps } from './NotificationTypeProps';
export declare class NotificationType extends ValueObject<NotificationTypeProps> {
    static readonly TYPES: {
        SharedVaultItemRemoved: string;
        SelfRemovedFromSharedVault: string;
        UserRemovedFromSharedVault: string;
        UserDesignatedAsSurvivor: string;
        UserAddedToSharedVault: string;
        SharedVaultInviteCanceled: string;
        SharedVaultFileUploaded: string;
        SharedVaultFileRemoved: string;
    };
    get value(): string;
    private constructor();
    static create(notificationType: string): Result<NotificationType>;
}
//# sourceMappingURL=NotificationType.d.ts.map