"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationPayloadIdentifierType = void 0;
const Result_1 = require("../Core/Result");
const ValueObject_1 = require("../Core/ValueObject");
class NotificationPayloadIdentifierType extends ValueObject_1.ValueObject {
    static TYPES = {
        SharedVaultUuid: 'shared_vault_uuid',
        UserUuid: 'user_uuid',
        SharedVaultInviteUuid: 'shared_vault_invite_uuid',
        ItemUuid: 'item_uuid',
    };
    constructor(props) {
        super(props);
    }
    get value() {
        return this.props.value;
    }
    static create(type) {
        if (!Object.values(this.TYPES).includes(type)) {
            return Result_1.Result.fail(`Invalid notification payload identifier type: ${type}`);
        }
        return Result_1.Result.ok(new NotificationPayloadIdentifierType({ value: type }));
    }
}
exports.NotificationPayloadIdentifierType = NotificationPayloadIdentifierType;
