"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractEnv = void 0;
class AbstractEnv {
    env = {};
    overrides;
    constructor(overrides = {}) {
        this.overrides = overrides;
    }
    get(key, optional = false) {
        if (!this.env) {
            this.load();
        }
        if (this.overrides[key]) {
            return this.overrides[key];
        }
        if (!process.env[key] && !optional) {
            throw new Error(`Environment variable ${key} not set`);
        }
        return process.env[key];
    }
    getAll() {
        if (!this.env) {
            this.load();
        }
        return this.env;
    }
}
exports.AbstractEnv = AbstractEnv;
