"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailLevel = void 0;
const Result_1 = require("../Core/Result");
const ValueObject_1 = require("../Core/ValueObject");
class EmailLevel extends ValueObject_1.ValueObject {
    static LEVELS = {
        System: 'SYSTEM',
        SignIn: 'SIGN_IN',
        Marketing: 'MARKETING',
        FailedCloudBackup: 'FAILED_CLOUD_BACKUP',
        FailedEmailBackup: 'FAILED_EMAIL_BACKUP',
    };
    get value() {
        return this.props.value;
    }
    constructor(props) {
        super(props);
    }
    static create(name) {
        const isValidName = Object.values(this.LEVELS).includes(name);
        if (!isValidName) {
            return Result_1.Result.fail(`Invalid subscription rejection level: ${name}`);
        }
        else {
            return Result_1.Result.ok(new EmailLevel({ value: name }));
        }
    }
}
exports.EmailLevel = EmailLevel;
