"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Validator = void 0;
const Result_1 = require("./Result");
class Validator {
    static UUID_ANY_VERSION_AND_VARIANT_REGEX = /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i;
    static EMAIL_REGEX = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    static isValidUuid(value) {
        const matchesUuidRegex = String(value).toLowerCase().match(Validator.UUID_ANY_VERSION_AND_VARIANT_REGEX) !== null;
        if (matchesUuidRegex) {
            return Result_1.Result.ok();
        }
        return Result_1.Result.fail(`Given value is not a valid uuid: ${value}`);
    }
    static isValidEmail(value) {
        const matchesUuidRegex = String(value).toLowerCase().match(Validator.EMAIL_REGEX) !== null;
        if (matchesUuidRegex) {
            return Result_1.Result.ok();
        }
        return Result_1.Result.fail(`Given value is not a valid email address: ${value}`);
    }
    static isString(value) {
        if (typeof value === 'string') {
            return Result_1.Result.ok();
        }
        return Result_1.Result.fail(`Given value is not a string: ${typeof value}`);
    }
    static isNotEmpty(value) {
        if (value instanceof Array && value.length === 0) {
            return Result_1.Result.fail(`Given value is empty: ${value}`);
        }
        if (value === null || value === undefined || value === '') {
            return Result_1.Result.fail(`Given value is empty: ${value}`);
        }
        return Result_1.Result.ok();
    }
    static isNotEmptyString(value) {
        const isStringResult = Validator.isString(value);
        if (isStringResult.isFailed()) {
            return isStringResult;
        }
        const isNotEmptyResult = Validator.isNotEmpty(value);
        if (isNotEmptyResult.isFailed()) {
            return isNotEmptyResult;
        }
        return Result_1.Result.ok();
    }
}
exports.Validator = Validator;
