"use strict";
/* istanbul ignore file */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Result = void 0;
class Result {
    isSuccess;
    error;
    value;
    constructor(isSuccess, error, value) {
        this.isSuccess = isSuccess;
        this.error = error;
        this.value = value;
        Object.freeze(this);
    }
    isFailed() {
        return !this.isSuccess;
    }
    getValue() {
        if (!this.isSuccess) {
            throw new Error(`Cannot get value of an unsuccessfull result: ${this.error}`);
        }
        return this.value;
    }
    getError() {
        if (this.isSuccess || this.error === undefined) {
            throw new Error('Cannot get an error of a successfull result');
        }
        return this.error;
    }
    static ok(value) {
        return new Result(true, undefined, value);
    }
    static fail(error) {
        return new Result(false, error);
    }
}
exports.Result = Result;
