"use strict";
/* istanbul ignore file */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Entity = void 0;
const UniqueEntityId_1 = require("./UniqueEntityId");
class Entity {
    props;
    _id;
    constructor(props, id) {
        this.props = props;
        this._id = id ? id : new UniqueEntityId_1.UniqueEntityId();
    }
    get id() {
        return this._id;
    }
    equals(object) {
        if (object == null || object == undefined) {
            return false;
        }
        if (this === object) {
            return true;
        }
        if (!(object instanceof Entity)) {
            return false;
        }
        return this._id.equals(object._id);
    }
}
exports.Entity = Entity;
