"use strict";
/* istanbul ignore file */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Change = void 0;
const Result_1 = require("./Result");
class Change {
    static TYPES = {
        Add: 'add',
        Remove: 'remove',
        Modify: 'modify',
    };
    props;
    constructor(props) {
        this.props = Object.freeze(props);
    }
    static create(props) {
        if (!Object.values(Change.TYPES).includes(props.changeType)) {
            return Result_1.Result.fail('Invalid change type');
        }
        return Result_1.Result.ok(new Change(props));
    }
}
exports.Change = Change;
