"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Uuid = void 0;
const ValueObject_1 = require("../Core/ValueObject");
const Result_1 = require("../Core/Result");
const Validator_1 = require("../Core/Validator");
class Uuid extends ValueObject_1.ValueObject {
    get value() {
        return this.props.value;
    }
    constructor(props) {
        super(props);
    }
    static create(uuid) {
        const validUuidOrError = Validator_1.Validator.isValidUuid(uuid);
        if (validUuidOrError.isFailed()) {
            return Result_1.Result.fail(validUuidOrError.getError());
        }
        else {
            return Result_1.Result.ok(new Uuid({ value: uuid }));
        }
    }
}
exports.Uuid = Uuid;
