"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Username = void 0;
const ValueObject_1 = require("../Core/ValueObject");
const Result_1 = require("../Core/Result");
const Validator_1 = require("../Core/Validator");
class Username extends ValueObject_1.ValueObject {
    get value() {
        return this.props.value;
    }
    constructor(props) {
        super(props);
    }
    static create(username) {
        if (Validator_1.Validator.isString(username).isFailed()) {
            return Result_1.Result.fail('Username must be a string');
        }
        const trimmedAndLowerCasedUsername = username.trim().toLowerCase();
        if (Validator_1.Validator.isNotEmpty(trimmedAndLowerCasedUsername).isFailed()) {
            return Result_1.Result.fail('Username cannot be empty');
        }
        return Result_1.Result.ok(new Username({ value: trimmedAndLowerCasedUsername }));
    }
    isPotentiallyAPrivateUsernameAccount() {
        return this.value.length === 64 && !this.value.includes('@');
    }
}
exports.Username = Username;
