"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Timestamps = void 0;
const Result_1 = require("../Core/Result");
const ValueObject_1 = require("../Core/ValueObject");
class Timestamps extends ValueObject_1.ValueObject {
    get createdAt() {
        return this.props.createdAt;
    }
    get updatedAt() {
        return this.props.updatedAt;
    }
    constructor(props) {
        super(props);
    }
    static create(createdAt, updatedAt) {
        if (isNaN(createdAt) || typeof createdAt !== 'number') {
            return Result_1.Result.fail(`Could not create Timestamps. Creation date should be a number, given: ${createdAt}`);
        }
        if (isNaN(updatedAt) || typeof updatedAt !== 'number') {
            return Result_1.Result.fail(`Could not create Timestamps. Update date should be a number, given: ${updatedAt}`);
        }
        return Result_1.Result.ok(new Timestamps({ createdAt, updatedAt }));
    }
}
exports.Timestamps = Timestamps;
