"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoleNameCollection = void 0;
const ValueObject_1 = require("../Core/ValueObject");
const Result_1 = require("../Core/Result");
const RoleName_1 = require("./RoleName");
class RoleNameCollection extends ValueObject_1.ValueObject {
    get value() {
        return this.props.value;
    }
    includes(roleName) {
        for (const existingRoleName of this.props.value) {
            if (existingRoleName.value === roleName.value) {
                return true;
            }
        }
        return false;
    }
    hasARoleNameWithMoreOrEqualPowerTo(roleName) {
        for (const existingRoleName of this.props.value) {
            if (existingRoleName.hasMoreOrEqualPowerTo(roleName)) {
                return true;
            }
        }
        return false;
    }
    equals(roleNameCollection) {
        if (this.props.value.length !== roleNameCollection.value.length) {
            return false;
        }
        for (const roleName of roleNameCollection.value) {
            if (!this.includes(roleName)) {
                return false;
            }
        }
        return true;
    }
    constructor(props) {
        super(props);
    }
    static create(roleNameStrings) {
        const roleNames = [];
        for (const roleNameString of roleNameStrings) {
            const roleNameOrError = RoleName_1.RoleName.create(roleNameString);
            if (roleNameOrError.isFailed()) {
                return Result_1.Result.fail(roleNameOrError.getError());
            }
            roleNames.push(roleNameOrError.getValue());
        }
        return Result_1.Result.ok(new RoleNameCollection({ value: roleNames }));
    }
}
exports.RoleNameCollection = RoleNameCollection;
