import { ValueObject } from '../Core/ValueObject';
import { Result } from '../Core/Result';
import { RoleNameCollectionProps } from './RoleNameCollectionProps';
import { RoleName } from './RoleName';
export declare class RoleNameCollection extends ValueObject<RoleNameCollectionProps> {
    get value(): RoleName[];
    includes(roleName: RoleName): boolean;
    hasARoleNameWithMoreOrEqualPowerTo(roleName: RoleName): boolean;
    equals(roleNameCollection: RoleNameCollection): boolean;
    private constructor();
    static create(roleNameStrings: string[]): Result<RoleNameCollection>;
}
//# sourceMappingURL=RoleNameCollection.d.ts.map