"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoleName = void 0;
const ValueObject_1 = require("../Core/ValueObject");
const Result_1 = require("../Core/Result");
class RoleName extends ValueObject_1.ValueObject {
    static NAMES = {
        CoreUser: 'CORE_USER',
        PlusUser: 'PLUS_USER',
        ProUser: 'PRO_USER',
        InternalTeamUser: 'INTERNAL_TEAM_USER',
        VaultsUser: 'VAULTS_USER',
    };
    get value() {
        return this.props.value;
    }
    hasMoreOrEqualPowerTo(roleName) {
        switch (this.value) {
            case RoleName.NAMES.InternalTeamUser:
                return true;
            case RoleName.NAMES.ProUser:
                return [RoleName.NAMES.CoreUser, RoleName.NAMES.PlusUser, RoleName.NAMES.ProUser].includes(roleName.value);
            case RoleName.NAMES.PlusUser:
                return [RoleName.NAMES.CoreUser, RoleName.NAMES.PlusUser].includes(roleName.value);
            case RoleName.NAMES.CoreUser:
            case RoleName.NAMES.VaultsUser:
                return [RoleName.NAMES.CoreUser].includes(roleName.value);
            /*istanbul ignore next*/
            default:
                throw new Error(`Invalid role name: ${this.value}`);
        }
    }
    constructor(props) {
        super(props);
    }
    static create(name) {
        const isValidName = Object.values(this.NAMES).includes(name);
        if (!isValidName) {
            return Result_1.Result.fail(`Invalid role name: ${name}`);
        }
        else {
            return Result_1.Result.ok(new RoleName({ value: name }));
        }
    }
}
exports.RoleName = RoleName;
