import { ValueObject } from '../Core/ValueObject';
import { Result } from '../Core/Result';
import { RoleNameProps } from './RoleNameProps';
export declare class RoleName extends ValueObject<RoleNameProps> {
    static readonly NAMES: {
        CoreUser: string;
        PlusUser: string;
        ProUser: string;
        InternalTeamUser: string;
        VaultsUser: string;
    };
    get value(): string;
    hasMoreOrEqualPowerTo(roleName: RoleName): boolean;
    private constructor();
    static create(name: string): Result<RoleName>;
}
//# sourceMappingURL=RoleName.d.ts.map