"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Email = void 0;
const ValueObject_1 = require("../Core/ValueObject");
const Result_1 = require("../Core/Result");
const Validator_1 = require("../Core/Validator");
class Email extends ValueObject_1.ValueObject {
    get value() {
        return this.props.value;
    }
    constructor(props) {
        super(props);
    }
    static create(email) {
        if (Validator_1.Validator.isString(email).isFailed()) {
            return Result_1.Result.fail('Email must be a string');
        }
        const trimmedAndLowerCasedEmail = email.trim().toLowerCase();
        const emailValidation = Validator_1.Validator.isValidEmail(trimmedAndLowerCasedEmail);
        if (emailValidation.isFailed()) {
            return Result_1.Result.fail(emailValidation.getError());
        }
        return Result_1.Result.ok(new Email({ value: trimmedAndLowerCasedEmail }));
    }
}
exports.Email = Email;
