"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dates = void 0;
const Result_1 = require("../Core/Result");
const ValueObject_1 = require("../Core/ValueObject");
class Dates extends ValueObject_1.ValueObject {
    get createdAt() {
        return this.props.createdAt;
    }
    get updatedAt() {
        return this.props.updatedAt;
    }
    constructor(props) {
        super(props);
    }
    static create(createdAt, updatedAt) {
        if (!(createdAt instanceof Date)) {
            return Result_1.Result.fail(`Could not create Dates. Creation date should be a date object, given: ${createdAt}`);
        }
        if (!(updatedAt instanceof Date)) {
            return Result_1.Result.fail(`Could not create Dates. Update date should be a date object, given: ${updatedAt}`);
        }
        return Result_1.Result.ok(new Dates({ createdAt, updatedAt }));
    }
}
exports.Dates = Dates;
