"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentType = void 0;
const Result_1 = require("../Core/Result");
const ValueObject_1 = require("../Core/ValueObject");
class ContentType extends ValueObject_1.ValueObject {
    static TYPES = {
        Any: '*',
        Item: 'SF|Item',
        KeySystemItemsKey: 'SN|KeySystemItemsKey',
        KeySystemRootKey: 'SN|KeySystemRootKey',
        TrustedContact: 'SN|TrustedContact',
        VaultListing: 'SN|VaultListing',
        RootKey: 'SN|RootKey|NoSync',
        ItemsKey: 'SN|ItemsKey',
        EncryptedStorage: 'SN|EncryptedStorage',
        Note: 'Note',
        Tag: 'Tag',
        SmartView: 'SN|SmartTag',
        Component: 'SN|Component',
        Editor: 'SN|Editor',
        ActionsExtension: 'Extension',
        UserPrefs: 'SN|UserPreferences',
        HistorySession: 'SN|HistorySession',
        Theme: 'SN|Theme',
        File: 'SN|File',
        FilesafeCredentials: 'SN|FileSafe|Credentials',
        FilesafeFileMetadata: 'SN|FileSafe|FileMetadata',
        FilesafeIntegration: 'SN|FileSafe|Integration',
        ExtensionRepo: 'SN|ExtensionRepo',
    };
    displayNamesMap = {
        [ContentType.TYPES.ActionsExtension]: 'action-based extension',
        [ContentType.TYPES.Component]: 'component',
        [ContentType.TYPES.Editor]: 'editor',
        [ContentType.TYPES.File]: 'file',
        [ContentType.TYPES.FilesafeCredentials]: 'FileSafe credential',
        [ContentType.TYPES.FilesafeFileMetadata]: 'FileSafe file',
        [ContentType.TYPES.FilesafeIntegration]: 'FileSafe integration',
        [ContentType.TYPES.ItemsKey]: 'encryption key',
        [ContentType.TYPES.Note]: 'note',
        [ContentType.TYPES.SmartView]: 'smart view',
        [ContentType.TYPES.Tag]: 'tag',
        [ContentType.TYPES.Theme]: 'theme',
        [ContentType.TYPES.UserPrefs]: 'user preferences',
    };
    get value() {
        return this.props.value;
    }
    constructor(props) {
        super(props);
    }
    static create(type) {
        if (type === null) {
            return Result_1.Result.ok(new ContentType({ value: null }));
        }
        const isValidType = Object.values(this.TYPES).includes(type);
        if (!isValidType) {
            return Result_1.Result.fail(`Invalid content type: ${type}`);
        }
        else {
            return Result_1.Result.ok(new ContentType({ value: type }));
        }
    }
    getDisplayName() {
        if (!this.value) {
            return null;
        }
        return this.displayNamesMap[this.value] || this.value;
    }
}
exports.ContentType = ContentType;
